/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeleteApplicationReferenceDataSourceRequestMarshaller
implements Marshaller<Request<DeleteApplicationReferenceDataSourceRequest>, DeleteApplicationReferenceDataSourceRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteApplicationReferenceDataSourceRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeleteApplicationReferenceDataSourceRequest> marshall(DeleteApplicationReferenceDataSourceRequest deleteApplicationReferenceDataSourceRequest) {
        if (deleteApplicationReferenceDataSourceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteApplicationReferenceDataSourceRequest, "AmazonKinesisAnalytics");
        request.addHeader("X-Amz-Target", "KinesisAnalytics_20150814.DeleteApplicationReferenceDataSource");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteApplicationReferenceDataSourceRequest.getApplicationName() != null) {
                jsonGenerator.writeFieldName("ApplicationName").writeValue(deleteApplicationReferenceDataSourceRequest.getApplicationName());
            }
            if (deleteApplicationReferenceDataSourceRequest.getCurrentApplicationVersionId() != null) {
                jsonGenerator.writeFieldName("CurrentApplicationVersionId").writeValue(deleteApplicationReferenceDataSourceRequest.getCurrentApplicationVersionId().longValue());
            }
            if (deleteApplicationReferenceDataSourceRequest.getReferenceId() != null) {
                jsonGenerator.writeFieldName("ReferenceId").writeValue(deleteApplicationReferenceDataSourceRequest.getReferenceId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

