/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesisfirehose.model.RedshiftDestinationConfiguration;
import com.amazonaws.services.kinesisfirehose.model.transform.CopyCommandJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.S3DestinationConfigurationJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class RedshiftDestinationConfigurationJsonMarshaller {
    private static RedshiftDestinationConfigurationJsonMarshaller instance;

    public void marshall(RedshiftDestinationConfiguration redshiftDestinationConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (redshiftDestinationConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (redshiftDestinationConfiguration.getRoleARN() != null) {
                jsonGenerator.writeFieldName("RoleARN").writeValue(redshiftDestinationConfiguration.getRoleARN());
            }
            if (redshiftDestinationConfiguration.getClusterJDBCURL() != null) {
                jsonGenerator.writeFieldName("ClusterJDBCURL").writeValue(redshiftDestinationConfiguration.getClusterJDBCURL());
            }
            if (redshiftDestinationConfiguration.getCopyCommand() != null) {
                jsonGenerator.writeFieldName("CopyCommand");
                CopyCommandJsonMarshaller.getInstance().marshall(redshiftDestinationConfiguration.getCopyCommand(), jsonGenerator);
            }
            if (redshiftDestinationConfiguration.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(redshiftDestinationConfiguration.getUsername());
            }
            if (redshiftDestinationConfiguration.getPassword() != null) {
                jsonGenerator.writeFieldName("Password").writeValue(redshiftDestinationConfiguration.getPassword());
            }
            if (redshiftDestinationConfiguration.getS3Configuration() != null) {
                jsonGenerator.writeFieldName("S3Configuration");
                S3DestinationConfigurationJsonMarshaller.getInstance().marshall(redshiftDestinationConfiguration.getS3Configuration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RedshiftDestinationConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RedshiftDestinationConfigurationJsonMarshaller();
        }
        return instance;
    }
}

