/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.StreamDescription;
import com.amazonaws.services.kinesis.model.transform.ShardJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class StreamDescriptionJsonMarshaller {
    private static StreamDescriptionJsonMarshaller instance;

    public void marshall(StreamDescription streamDescription, StructuredJsonGenerator jsonGenerator) {
        if (streamDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList shardsList;
            jsonGenerator.writeStartObject();
            if (streamDescription.getStreamName() != null) {
                jsonGenerator.writeFieldName("StreamName").writeValue(streamDescription.getStreamName());
            }
            if (streamDescription.getStreamARN() != null) {
                jsonGenerator.writeFieldName("StreamARN").writeValue(streamDescription.getStreamARN());
            }
            if (streamDescription.getStreamStatus() != null) {
                jsonGenerator.writeFieldName("StreamStatus").writeValue(streamDescription.getStreamStatus());
            }
            if (!(shardsList = (SdkInternalList)streamDescription.getShards()).isEmpty() || !shardsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Shards");
                jsonGenerator.writeStartArray();
                for (Shard shardsListValue : shardsList) {
                    if (shardsListValue == null) continue;
                    ShardJsonMarshaller.getInstance().marshall(shardsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (streamDescription.getHasMoreShards() != null) {
                jsonGenerator.writeFieldName("HasMoreShards").writeValue(streamDescription.getHasMoreShards().booleanValue());
            }
            if (streamDescription.getRetentionPeriodHours() != null) {
                jsonGenerator.writeFieldName("RetentionPeriodHours").writeValue(streamDescription.getRetentionPeriodHours().intValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StreamDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StreamDescriptionJsonMarshaller();
        }
        return instance;
    }
}

