/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesisfirehose.model.S3DestinationDescription;
import com.amazonaws.services.kinesisfirehose.model.transform.BufferingHintsJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.EncryptionConfigurationJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class S3DestinationDescriptionJsonMarshaller {
    private static S3DestinationDescriptionJsonMarshaller instance;

    public void marshall(S3DestinationDescription s3DestinationDescription, StructuredJsonGenerator jsonGenerator) {
        if (s3DestinationDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (s3DestinationDescription.getRoleARN() != null) {
                jsonGenerator.writeFieldName("RoleARN").writeValue(s3DestinationDescription.getRoleARN());
            }
            if (s3DestinationDescription.getBucketARN() != null) {
                jsonGenerator.writeFieldName("BucketARN").writeValue(s3DestinationDescription.getBucketARN());
            }
            if (s3DestinationDescription.getPrefix() != null) {
                jsonGenerator.writeFieldName("Prefix").writeValue(s3DestinationDescription.getPrefix());
            }
            if (s3DestinationDescription.getBufferingHints() != null) {
                jsonGenerator.writeFieldName("BufferingHints");
                BufferingHintsJsonMarshaller.getInstance().marshall(s3DestinationDescription.getBufferingHints(), jsonGenerator);
            }
            if (s3DestinationDescription.getCompressionFormat() != null) {
                jsonGenerator.writeFieldName("CompressionFormat").writeValue(s3DestinationDescription.getCompressionFormat());
            }
            if (s3DestinationDescription.getEncryptionConfiguration() != null) {
                jsonGenerator.writeFieldName("EncryptionConfiguration");
                EncryptionConfigurationJsonMarshaller.getInstance().marshall(s3DestinationDescription.getEncryptionConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static S3DestinationDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new S3DestinationDescriptionJsonMarshaller();
        }
        return instance;
    }
}

