/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesisfirehose.model.S3DestinationConfiguration;
import com.amazonaws.services.kinesisfirehose.model.transform.BufferingHintsJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.EncryptionConfigurationJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class S3DestinationConfigurationJsonMarshaller {
    private static S3DestinationConfigurationJsonMarshaller instance;

    public void marshall(S3DestinationConfiguration s3DestinationConfiguration, SdkJsonGenerator jsonGenerator) {
        if (s3DestinationConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (s3DestinationConfiguration.getRoleARN() != null) {
                jsonGenerator.writeFieldName("RoleARN").writeValue(s3DestinationConfiguration.getRoleARN());
            }
            if (s3DestinationConfiguration.getBucketARN() != null) {
                jsonGenerator.writeFieldName("BucketARN").writeValue(s3DestinationConfiguration.getBucketARN());
            }
            if (s3DestinationConfiguration.getPrefix() != null) {
                jsonGenerator.writeFieldName("Prefix").writeValue(s3DestinationConfiguration.getPrefix());
            }
            if (s3DestinationConfiguration.getBufferingHints() != null) {
                jsonGenerator.writeFieldName("BufferingHints");
                BufferingHintsJsonMarshaller.getInstance().marshall(s3DestinationConfiguration.getBufferingHints(), jsonGenerator);
            }
            if (s3DestinationConfiguration.getCompressionFormat() != null) {
                jsonGenerator.writeFieldName("CompressionFormat").writeValue(s3DestinationConfiguration.getCompressionFormat());
            }
            if (s3DestinationConfiguration.getEncryptionConfiguration() != null) {
                jsonGenerator.writeFieldName("EncryptionConfiguration");
                EncryptionConfigurationJsonMarshaller.getInstance().marshall(s3DestinationConfiguration.getEncryptionConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static S3DestinationConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new S3DestinationConfigurationJsonMarshaller();
        }
        return instance;
    }
}

