/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesisfirehose.model.DestinationDescription;
import com.amazonaws.services.kinesisfirehose.model.transform.RedshiftDestinationDescriptionJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.S3DestinationDescriptionJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class DestinationDescriptionJsonMarshaller {
    private static DestinationDescriptionJsonMarshaller instance;

    public void marshall(DestinationDescription destinationDescription, SdkJsonGenerator jsonGenerator) {
        if (destinationDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (destinationDescription.getDestinationId() != null) {
                jsonGenerator.writeFieldName("DestinationId").writeValue(destinationDescription.getDestinationId());
            }
            if (destinationDescription.getS3DestinationDescription() != null) {
                jsonGenerator.writeFieldName("S3DestinationDescription");
                S3DestinationDescriptionJsonMarshaller.getInstance().marshall(destinationDescription.getS3DestinationDescription(), jsonGenerator);
            }
            if (destinationDescription.getRedshiftDestinationDescription() != null) {
                jsonGenerator.writeFieldName("RedshiftDestinationDescription");
                RedshiftDestinationDescriptionJsonMarshaller.getInstance().marshall(destinationDescription.getRedshiftDestinationDescription(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DestinationDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DestinationDescriptionJsonMarshaller();
        }
        return instance;
    }
}

