/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesisfirehose.model.EncryptionConfiguration;
import com.amazonaws.services.kinesisfirehose.model.transform.KMSEncryptionConfigJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class EncryptionConfigurationJsonMarshaller {
    private static EncryptionConfigurationJsonMarshaller instance;

    public void marshall(EncryptionConfiguration encryptionConfiguration, JSONWriter jsonWriter) {
        if (encryptionConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (encryptionConfiguration.getNoEncryptionConfig() != null) {
                jsonWriter.key("NoEncryptionConfig").value((Object)encryptionConfiguration.getNoEncryptionConfig());
            }
            if (encryptionConfiguration.getKMSEncryptionConfig() != null) {
                jsonWriter.key("KMSEncryptionConfig");
                KMSEncryptionConfigJsonMarshaller.getInstance().marshall(encryptionConfiguration.getKMSEncryptionConfig(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EncryptionConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EncryptionConfigurationJsonMarshaller();
        }
        return instance;
    }
}

