/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.keyspaces.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.keyspaces.model.SchemaDefinition;
import java.util.List;

@SdkInternalApi
public class SchemaDefinitionMarshaller {
    private static final MarshallingInfo<List> ALLCOLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allColumns").build();
    private static final MarshallingInfo<List> PARTITIONKEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("partitionKeys").build();
    private static final MarshallingInfo<List> CLUSTERINGKEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clusteringKeys").build();
    private static final MarshallingInfo<List> STATICCOLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("staticColumns").build();
    private static final SchemaDefinitionMarshaller instance = new SchemaDefinitionMarshaller();

    public static SchemaDefinitionMarshaller getInstance() {
        return instance;
    }

    public void marshall(SchemaDefinition schemaDefinition, ProtocolMarshaller protocolMarshaller) {
        if (schemaDefinition == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(schemaDefinition.getAllColumns(), ALLCOLUMNS_BINDING);
            protocolMarshaller.marshall(schemaDefinition.getPartitionKeys(), PARTITIONKEYS_BINDING);
            protocolMarshaller.marshall(schemaDefinition.getClusteringKeys(), CLUSTERINGKEYS_BINDING);
            protocolMarshaller.marshall(schemaDefinition.getStaticColumns(), STATICCOLUMNS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

