/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.keyspaces.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.keyspaces.model.TableSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListTablesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<TableSummary> tables;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListTablesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<TableSummary> getTables() {
        return this.tables;
    }

    public void setTables(Collection<TableSummary> tables) {
        if (tables == null) {
            this.tables = null;
            return;
        }
        this.tables = new ArrayList<TableSummary>(tables);
    }

    public ListTablesResult withTables(TableSummary ... tables) {
        if (this.tables == null) {
            this.setTables(new ArrayList<TableSummary>(tables.length));
        }
        for (TableSummary ele : tables) {
            this.tables.add(ele);
        }
        return this;
    }

    public ListTablesResult withTables(Collection<TableSummary> tables) {
        this.setTables(tables);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getTables() != null) {
            sb.append("Tables: ").append(this.getTables());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTablesResult)) {
            return false;
        }
        ListTablesResult other = (ListTablesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getTables() == null ^ this.getTables() == null) {
            return false;
        }
        return other.getTables() == null || other.getTables().equals(this.getTables());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getTables() == null ? 0 : this.getTables().hashCode());
        return hashCode;
    }

    public ListTablesResult clone() {
        try {
            return (ListTablesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

