/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kendra.model.DocumentInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchGetDocumentStatusRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String indexId;
    private List<DocumentInfo> documentInfoList;

    public void setIndexId(String indexId) {
        this.indexId = indexId;
    }

    public String getIndexId() {
        return this.indexId;
    }

    public BatchGetDocumentStatusRequest withIndexId(String indexId) {
        this.setIndexId(indexId);
        return this;
    }

    public List<DocumentInfo> getDocumentInfoList() {
        return this.documentInfoList;
    }

    public void setDocumentInfoList(Collection<DocumentInfo> documentInfoList) {
        if (documentInfoList == null) {
            this.documentInfoList = null;
            return;
        }
        this.documentInfoList = new ArrayList<DocumentInfo>(documentInfoList);
    }

    public BatchGetDocumentStatusRequest withDocumentInfoList(DocumentInfo ... documentInfoList) {
        if (this.documentInfoList == null) {
            this.setDocumentInfoList(new ArrayList<DocumentInfo>(documentInfoList.length));
        }
        for (DocumentInfo ele : documentInfoList) {
            this.documentInfoList.add(ele);
        }
        return this;
    }

    public BatchGetDocumentStatusRequest withDocumentInfoList(Collection<DocumentInfo> documentInfoList) {
        this.setDocumentInfoList(documentInfoList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIndexId() != null) {
            sb.append("IndexId: ").append(this.getIndexId()).append(",");
        }
        if (this.getDocumentInfoList() != null) {
            sb.append("DocumentInfoList: ").append(this.getDocumentInfoList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDocumentStatusRequest)) {
            return false;
        }
        BatchGetDocumentStatusRequest other = (BatchGetDocumentStatusRequest)obj;
        if (other.getIndexId() == null ^ this.getIndexId() == null) {
            return false;
        }
        if (other.getIndexId() != null && !other.getIndexId().equals(this.getIndexId())) {
            return false;
        }
        if (other.getDocumentInfoList() == null ^ this.getDocumentInfoList() == null) {
            return false;
        }
        return other.getDocumentInfoList() == null || other.getDocumentInfoList().equals(this.getDocumentInfoList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIndexId() == null ? 0 : this.getIndexId().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentInfoList() == null ? 0 : this.getDocumentInfoList().hashCode());
        return hashCode;
    }

    public BatchGetDocumentStatusRequest clone() {
        return (BatchGetDocumentStatusRequest)super.clone();
    }
}

