/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafkaconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kafkaconnect.model.CustomPluginLocation;

@SdkInternalApi
public class CustomPluginLocationMarshaller {
    private static final MarshallingInfo<StructuredPojo> S3LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Location").build();
    private static final CustomPluginLocationMarshaller instance = new CustomPluginLocationMarshaller();

    public static CustomPluginLocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(CustomPluginLocation customPluginLocation, ProtocolMarshaller protocolMarshaller) {
        if (customPluginLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)customPluginLocation.getS3Location(), S3LOCATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

