/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafkaconnect;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.kafkaconnect.AWSKafkaConnect;
import com.amazonaws.services.kafkaconnect.AWSKafkaConnectClientBuilder;
import com.amazonaws.services.kafkaconnect.model.AWSKafkaConnectException;
import com.amazonaws.services.kafkaconnect.model.CreateConnectorRequest;
import com.amazonaws.services.kafkaconnect.model.CreateConnectorResult;
import com.amazonaws.services.kafkaconnect.model.CreateCustomPluginRequest;
import com.amazonaws.services.kafkaconnect.model.CreateCustomPluginResult;
import com.amazonaws.services.kafkaconnect.model.CreateWorkerConfigurationRequest;
import com.amazonaws.services.kafkaconnect.model.CreateWorkerConfigurationResult;
import com.amazonaws.services.kafkaconnect.model.DeleteConnectorRequest;
import com.amazonaws.services.kafkaconnect.model.DeleteConnectorResult;
import com.amazonaws.services.kafkaconnect.model.DeleteCustomPluginRequest;
import com.amazonaws.services.kafkaconnect.model.DeleteCustomPluginResult;
import com.amazonaws.services.kafkaconnect.model.DescribeConnectorRequest;
import com.amazonaws.services.kafkaconnect.model.DescribeConnectorResult;
import com.amazonaws.services.kafkaconnect.model.DescribeCustomPluginRequest;
import com.amazonaws.services.kafkaconnect.model.DescribeCustomPluginResult;
import com.amazonaws.services.kafkaconnect.model.DescribeWorkerConfigurationRequest;
import com.amazonaws.services.kafkaconnect.model.DescribeWorkerConfigurationResult;
import com.amazonaws.services.kafkaconnect.model.ListConnectorsRequest;
import com.amazonaws.services.kafkaconnect.model.ListConnectorsResult;
import com.amazonaws.services.kafkaconnect.model.ListCustomPluginsRequest;
import com.amazonaws.services.kafkaconnect.model.ListCustomPluginsResult;
import com.amazonaws.services.kafkaconnect.model.ListWorkerConfigurationsRequest;
import com.amazonaws.services.kafkaconnect.model.ListWorkerConfigurationsResult;
import com.amazonaws.services.kafkaconnect.model.UpdateConnectorRequest;
import com.amazonaws.services.kafkaconnect.model.UpdateConnectorResult;
import com.amazonaws.services.kafkaconnect.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.CreateConnectorRequestProtocolMarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.CreateConnectorResultJsonUnmarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.CreateCustomPluginRequestProtocolMarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.CreateCustomPluginResultJsonUnmarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.CreateWorkerConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.CreateWorkerConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.DeleteConnectorRequestProtocolMarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.DeleteConnectorResultJsonUnmarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.DeleteCustomPluginRequestProtocolMarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.DeleteCustomPluginResultJsonUnmarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.DescribeConnectorRequestProtocolMarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.DescribeConnectorResultJsonUnmarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.DescribeCustomPluginRequestProtocolMarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.DescribeCustomPluginResultJsonUnmarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.DescribeWorkerConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.DescribeWorkerConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.ForbiddenExceptionUnmarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.ListConnectorsRequestProtocolMarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.ListConnectorsResultJsonUnmarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.ListCustomPluginsRequestProtocolMarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.ListCustomPluginsResultJsonUnmarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.ListWorkerConfigurationsRequestProtocolMarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.ListWorkerConfigurationsResultJsonUnmarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.TooManyRequestsExceptionUnmarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.UnauthorizedExceptionUnmarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.UpdateConnectorRequestProtocolMarshaller;
import com.amazonaws.services.kafkaconnect.model.transform.UpdateConnectorResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSKafkaConnectClient
extends AmazonWebServiceClient
implements AWSKafkaConnect {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSKafkaConnect.class);
    private static final String DEFAULT_SIGNING_NAME = "kafkaconnect";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnauthorizedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ForbiddenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TooManyRequestsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerErrorExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSKafkaConnectException.class));

    public static AWSKafkaConnectClientBuilder builder() {
        return AWSKafkaConnectClientBuilder.standard();
    }

    AWSKafkaConnectClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSKafkaConnectClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("kafkaconnect.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/kafkaconnect/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/kafkaconnect/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateConnectorResult createConnector(CreateConnectorRequest request) {
        request = (CreateConnectorRequest)this.beforeClientExecution(request);
        return this.executeCreateConnector(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateConnectorResult executeCreateConnector(CreateConnectorRequest createConnectorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createConnectorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateConnectorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateConnectorRequestProtocolMarshaller(protocolFactory).marshall((CreateConnectorRequest)super.beforeMarshalling((AmazonWebServiceRequest)createConnectorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"KafkaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateConnector");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateConnectorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateConnectorResult createConnectorResult = (CreateConnectorResult)response.getAwsResponse();
            return createConnectorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateCustomPluginResult createCustomPlugin(CreateCustomPluginRequest request) {
        request = (CreateCustomPluginRequest)this.beforeClientExecution(request);
        return this.executeCreateCustomPlugin(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateCustomPluginResult executeCreateCustomPlugin(CreateCustomPluginRequest createCustomPluginRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createCustomPluginRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateCustomPluginRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateCustomPluginRequestProtocolMarshaller(protocolFactory).marshall((CreateCustomPluginRequest)super.beforeMarshalling((AmazonWebServiceRequest)createCustomPluginRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"KafkaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateCustomPlugin");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateCustomPluginResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateCustomPluginResult createCustomPluginResult = (CreateCustomPluginResult)response.getAwsResponse();
            return createCustomPluginResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateWorkerConfigurationResult createWorkerConfiguration(CreateWorkerConfigurationRequest request) {
        request = (CreateWorkerConfigurationRequest)this.beforeClientExecution(request);
        return this.executeCreateWorkerConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateWorkerConfigurationResult executeCreateWorkerConfiguration(CreateWorkerConfigurationRequest createWorkerConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createWorkerConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateWorkerConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateWorkerConfigurationRequestProtocolMarshaller(protocolFactory).marshall((CreateWorkerConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createWorkerConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"KafkaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateWorkerConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateWorkerConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateWorkerConfigurationResult createWorkerConfigurationResult = (CreateWorkerConfigurationResult)response.getAwsResponse();
            return createWorkerConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteConnectorResult deleteConnector(DeleteConnectorRequest request) {
        request = (DeleteConnectorRequest)this.beforeClientExecution(request);
        return this.executeDeleteConnector(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteConnectorResult executeDeleteConnector(DeleteConnectorRequest deleteConnectorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteConnectorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteConnectorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteConnectorRequestProtocolMarshaller(protocolFactory).marshall((DeleteConnectorRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteConnectorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"KafkaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteConnector");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteConnectorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteConnectorResult deleteConnectorResult = (DeleteConnectorResult)response.getAwsResponse();
            return deleteConnectorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteCustomPluginResult deleteCustomPlugin(DeleteCustomPluginRequest request) {
        request = (DeleteCustomPluginRequest)this.beforeClientExecution(request);
        return this.executeDeleteCustomPlugin(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteCustomPluginResult executeDeleteCustomPlugin(DeleteCustomPluginRequest deleteCustomPluginRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteCustomPluginRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteCustomPluginRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteCustomPluginRequestProtocolMarshaller(protocolFactory).marshall((DeleteCustomPluginRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteCustomPluginRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"KafkaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteCustomPlugin");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteCustomPluginResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteCustomPluginResult deleteCustomPluginResult = (DeleteCustomPluginResult)response.getAwsResponse();
            return deleteCustomPluginResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeConnectorResult describeConnector(DescribeConnectorRequest request) {
        request = (DescribeConnectorRequest)this.beforeClientExecution(request);
        return this.executeDescribeConnector(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeConnectorResult executeDescribeConnector(DescribeConnectorRequest describeConnectorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConnectorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeConnectorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeConnectorRequestProtocolMarshaller(protocolFactory).marshall((DescribeConnectorRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeConnectorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"KafkaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeConnector");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeConnectorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeConnectorResult describeConnectorResult = (DescribeConnectorResult)response.getAwsResponse();
            return describeConnectorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeCustomPluginResult describeCustomPlugin(DescribeCustomPluginRequest request) {
        request = (DescribeCustomPluginRequest)this.beforeClientExecution(request);
        return this.executeDescribeCustomPlugin(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeCustomPluginResult executeDescribeCustomPlugin(DescribeCustomPluginRequest describeCustomPluginRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeCustomPluginRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeCustomPluginRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeCustomPluginRequestProtocolMarshaller(protocolFactory).marshall((DescribeCustomPluginRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeCustomPluginRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"KafkaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeCustomPlugin");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeCustomPluginResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeCustomPluginResult describeCustomPluginResult = (DescribeCustomPluginResult)response.getAwsResponse();
            return describeCustomPluginResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeWorkerConfigurationResult describeWorkerConfiguration(DescribeWorkerConfigurationRequest request) {
        request = (DescribeWorkerConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDescribeWorkerConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeWorkerConfigurationResult executeDescribeWorkerConfiguration(DescribeWorkerConfigurationRequest describeWorkerConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeWorkerConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeWorkerConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeWorkerConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DescribeWorkerConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeWorkerConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"KafkaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeWorkerConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeWorkerConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeWorkerConfigurationResult describeWorkerConfigurationResult = (DescribeWorkerConfigurationResult)response.getAwsResponse();
            return describeWorkerConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListConnectorsResult listConnectors(ListConnectorsRequest request) {
        request = (ListConnectorsRequest)this.beforeClientExecution(request);
        return this.executeListConnectors(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListConnectorsResult executeListConnectors(ListConnectorsRequest listConnectorsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listConnectorsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListConnectorsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListConnectorsRequestProtocolMarshaller(protocolFactory).marshall((ListConnectorsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listConnectorsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"KafkaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListConnectors");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListConnectorsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListConnectorsResult listConnectorsResult = (ListConnectorsResult)response.getAwsResponse();
            return listConnectorsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListCustomPluginsResult listCustomPlugins(ListCustomPluginsRequest request) {
        request = (ListCustomPluginsRequest)this.beforeClientExecution(request);
        return this.executeListCustomPlugins(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListCustomPluginsResult executeListCustomPlugins(ListCustomPluginsRequest listCustomPluginsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listCustomPluginsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListCustomPluginsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListCustomPluginsRequestProtocolMarshaller(protocolFactory).marshall((ListCustomPluginsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listCustomPluginsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"KafkaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListCustomPlugins");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListCustomPluginsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListCustomPluginsResult listCustomPluginsResult = (ListCustomPluginsResult)response.getAwsResponse();
            return listCustomPluginsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListWorkerConfigurationsResult listWorkerConfigurations(ListWorkerConfigurationsRequest request) {
        request = (ListWorkerConfigurationsRequest)this.beforeClientExecution(request);
        return this.executeListWorkerConfigurations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListWorkerConfigurationsResult executeListWorkerConfigurations(ListWorkerConfigurationsRequest listWorkerConfigurationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listWorkerConfigurationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListWorkerConfigurationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListWorkerConfigurationsRequestProtocolMarshaller(protocolFactory).marshall((ListWorkerConfigurationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listWorkerConfigurationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"KafkaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListWorkerConfigurations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListWorkerConfigurationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListWorkerConfigurationsResult listWorkerConfigurationsResult = (ListWorkerConfigurationsResult)response.getAwsResponse();
            return listWorkerConfigurationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateConnectorResult updateConnector(UpdateConnectorRequest request) {
        request = (UpdateConnectorRequest)this.beforeClientExecution(request);
        return this.executeUpdateConnector(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateConnectorResult executeUpdateConnector(UpdateConnectorRequest updateConnectorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateConnectorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateConnectorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateConnectorRequestProtocolMarshaller(protocolFactory).marshall((UpdateConnectorRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateConnectorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"KafkaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateConnector");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateConnectorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateConnectorResult updateConnectorResult = (UpdateConnectorResult)response.getAwsResponse();
            return updateConnectorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

