/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kafka.model.ServerlessClientAuthentication;
import com.amazonaws.services.kafka.model.VpcConfig;
import com.amazonaws.services.kafka.model.transform.ServerlessRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ServerlessRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private List<VpcConfig> vpcConfigs;
    private ServerlessClientAuthentication clientAuthentication;

    public List<VpcConfig> getVpcConfigs() {
        return this.vpcConfigs;
    }

    public void setVpcConfigs(Collection<VpcConfig> vpcConfigs) {
        if (vpcConfigs == null) {
            this.vpcConfigs = null;
            return;
        }
        this.vpcConfigs = new ArrayList<VpcConfig>(vpcConfigs);
    }

    public ServerlessRequest withVpcConfigs(VpcConfig ... vpcConfigs) {
        if (this.vpcConfigs == null) {
            this.setVpcConfigs(new ArrayList<VpcConfig>(vpcConfigs.length));
        }
        for (VpcConfig ele : vpcConfigs) {
            this.vpcConfigs.add(ele);
        }
        return this;
    }

    public ServerlessRequest withVpcConfigs(Collection<VpcConfig> vpcConfigs) {
        this.setVpcConfigs(vpcConfigs);
        return this;
    }

    public void setClientAuthentication(ServerlessClientAuthentication clientAuthentication) {
        this.clientAuthentication = clientAuthentication;
    }

    public ServerlessClientAuthentication getClientAuthentication() {
        return this.clientAuthentication;
    }

    public ServerlessRequest withClientAuthentication(ServerlessClientAuthentication clientAuthentication) {
        this.setClientAuthentication(clientAuthentication);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVpcConfigs() != null) {
            sb.append("VpcConfigs: ").append(this.getVpcConfigs()).append(",");
        }
        if (this.getClientAuthentication() != null) {
            sb.append("ClientAuthentication: ").append(this.getClientAuthentication());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerlessRequest)) {
            return false;
        }
        ServerlessRequest other = (ServerlessRequest)obj;
        if (other.getVpcConfigs() == null ^ this.getVpcConfigs() == null) {
            return false;
        }
        if (other.getVpcConfigs() != null && !other.getVpcConfigs().equals(this.getVpcConfigs())) {
            return false;
        }
        if (other.getClientAuthentication() == null ^ this.getClientAuthentication() == null) {
            return false;
        }
        return other.getClientAuthentication() == null || other.getClientAuthentication().equals(this.getClientAuthentication());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVpcConfigs() == null ? 0 : this.getVpcConfigs().hashCode());
        hashCode = 31 * hashCode + (this.getClientAuthentication() == null ? 0 : this.getClientAuthentication().hashCode());
        return hashCode;
    }

    public ServerlessRequest clone() {
        try {
            return (ServerlessRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServerlessRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

