/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kafka.model.UnprocessedScramSecret;

@SdkInternalApi
public class UnprocessedScramSecretMarshaller {
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorCode").build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorMessage").build();
    private static final MarshallingInfo<String> SECRETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secretArn").build();
    private static final UnprocessedScramSecretMarshaller instance = new UnprocessedScramSecretMarshaller();

    public static UnprocessedScramSecretMarshaller getInstance() {
        return instance;
    }

    public void marshall(UnprocessedScramSecret unprocessedScramSecret, ProtocolMarshaller protocolMarshaller) {
        if (unprocessedScramSecret == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)unprocessedScramSecret.getErrorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)unprocessedScramSecret.getErrorMessage(), ERRORMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)unprocessedScramSecret.getSecretArn(), SECRETARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

