/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ivsrealtime;

import javax.annotation.Generated;

import com.amazonaws.services.ivsrealtime.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonIVSRealTime}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonIVSRealTime implements AmazonIVSRealTime {

    protected AbstractAmazonIVSRealTime() {
    }

    @Override
    public CreateParticipantTokenResult createParticipantToken(CreateParticipantTokenRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateStageResult createStage(CreateStageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteStageResult deleteStage(DeleteStageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisconnectParticipantResult disconnectParticipant(DisconnectParticipantRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetParticipantResult getParticipant(GetParticipantRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetStageResult getStage(GetStageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetStageSessionResult getStageSession(GetStageSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListParticipantEventsResult listParticipantEvents(ListParticipantEventsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListParticipantsResult listParticipants(ListParticipantsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListStageSessionsResult listStageSessions(ListStageSessionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListStagesResult listStages(ListStagesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateStageResult updateStage(UpdateStageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
