/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ivs.model.Stream;
import java.util.Date;

@SdkInternalApi
public class StreamMarshaller {
    private static final MarshallingInfo<String> CHANNELARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelArn").build();
    private static final MarshallingInfo<String> STREAMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamId").build();
    private static final MarshallingInfo<String> PLAYBACKURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("playbackUrl").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").build();
    private static final MarshallingInfo<String> HEALTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("health").build();
    private static final MarshallingInfo<Long> VIEWERCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("viewerCount").build();
    private static final StreamMarshaller instance = new StreamMarshaller();

    public static StreamMarshaller getInstance() {
        return instance;
    }

    public void marshall(Stream stream, ProtocolMarshaller protocolMarshaller) {
        if (stream == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)stream.getChannelArn(), CHANNELARN_BINDING);
            protocolMarshaller.marshall((Object)stream.getStreamId(), STREAMID_BINDING);
            protocolMarshaller.marshall((Object)stream.getPlaybackUrl(), PLAYBACKURL_BINDING);
            protocolMarshaller.marshall((Object)stream.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)stream.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)stream.getHealth(), HEALTH_BINDING);
            protocolMarshaller.marshall((Object)stream.getViewerCount(), VIEWERCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

