/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ivs.model.RenditionConfigurationRendition;
import com.amazonaws.services.ivs.model.RenditionConfigurationRenditionSelection;
import com.amazonaws.services.ivs.model.transform.RenditionConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RenditionConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String renditionSelection;
    private List<String> renditions;

    public void setRenditionSelection(String renditionSelection) {
        this.renditionSelection = renditionSelection;
    }

    public String getRenditionSelection() {
        return this.renditionSelection;
    }

    public RenditionConfiguration withRenditionSelection(String renditionSelection) {
        this.setRenditionSelection(renditionSelection);
        return this;
    }

    public RenditionConfiguration withRenditionSelection(RenditionConfigurationRenditionSelection renditionSelection) {
        this.renditionSelection = renditionSelection.toString();
        return this;
    }

    public List<String> getRenditions() {
        return this.renditions;
    }

    public void setRenditions(Collection<String> renditions) {
        if (renditions == null) {
            this.renditions = null;
            return;
        }
        this.renditions = new ArrayList<String>(renditions);
    }

    public RenditionConfiguration withRenditions(String ... renditions) {
        if (this.renditions == null) {
            this.setRenditions(new ArrayList<String>(renditions.length));
        }
        for (String ele : renditions) {
            this.renditions.add(ele);
        }
        return this;
    }

    public RenditionConfiguration withRenditions(Collection<String> renditions) {
        this.setRenditions(renditions);
        return this;
    }

    public RenditionConfiguration withRenditions(RenditionConfigurationRendition ... renditions) {
        ArrayList<String> renditionsCopy = new ArrayList<String>(renditions.length);
        for (RenditionConfigurationRendition value : renditions) {
            renditionsCopy.add(value.toString());
        }
        if (this.getRenditions() == null) {
            this.setRenditions(renditionsCopy);
        } else {
            this.getRenditions().addAll(renditionsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRenditionSelection() != null) {
            sb.append("RenditionSelection: ").append(this.getRenditionSelection()).append(",");
        }
        if (this.getRenditions() != null) {
            sb.append("Renditions: ").append(this.getRenditions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenditionConfiguration)) {
            return false;
        }
        RenditionConfiguration other = (RenditionConfiguration)obj;
        if (other.getRenditionSelection() == null ^ this.getRenditionSelection() == null) {
            return false;
        }
        if (other.getRenditionSelection() != null && !other.getRenditionSelection().equals(this.getRenditionSelection())) {
            return false;
        }
        if (other.getRenditions() == null ^ this.getRenditions() == null) {
            return false;
        }
        return other.getRenditions() == null || other.getRenditions().equals(this.getRenditions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRenditionSelection() == null ? 0 : this.getRenditionSelection().hashCode());
        hashCode = 31 * hashCode + (this.getRenditions() == null ? 0 : this.getRenditions().hashCode());
        return hashCode;
    }

    public RenditionConfiguration clone() {
        try {
            return (RenditionConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RenditionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

