/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ivs.model.StreamSession;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class StreamSessionMarshaller {
    private static final MarshallingInfo<StructuredPojo> CHANNEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channel").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<StructuredPojo> INGESTCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ingestConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> RECORDINGCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recordingConfiguration").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> STREAMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamId").build();
    private static final MarshallingInfo<List> TRUNCATEDEVENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("truncatedEvents").build();
    private static final StreamSessionMarshaller instance = new StreamSessionMarshaller();

    public static StreamSessionMarshaller getInstance() {
        return instance;
    }

    public void marshall(StreamSession streamSession, ProtocolMarshaller protocolMarshaller) {
        if (streamSession == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)streamSession.getChannel(), CHANNEL_BINDING);
            protocolMarshaller.marshall((Object)streamSession.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)streamSession.getIngestConfiguration(), INGESTCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)streamSession.getRecordingConfiguration(), RECORDINGCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)streamSession.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)streamSession.getStreamId(), STREAMID_BINDING);
            protocolMarshaller.marshall(streamSession.getTruncatedEvents(), TRUNCATEDEVENTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

