/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotwireless.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * OTAA device object for v1.0.x
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/OtaaV1_0_x" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class OtaaV10X implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The AppKey value.
     * </p>
     */
    private String appKey;
    /**
     * <p>
     * The AppEUI value. You specify this value when using LoRaWAN versions v1.0.2 or v1.0.3.
     * </p>
     */
    private String appEui;
    /**
     * <p>
     * The JoinEUI value. You specify this value instead of the AppEUI when using LoRaWAN version v1.0.4.
     * </p>
     */
    private String joinEui;
    /**
     * <p>
     * The GenAppKey value.
     * </p>
     */
    private String genAppKey;

    /**
     * <p>
     * The AppKey value.
     * </p>
     * 
     * @param appKey
     *        The AppKey value.
     */

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    /**
     * <p>
     * The AppKey value.
     * </p>
     * 
     * @return The AppKey value.
     */

    public String getAppKey() {
        return this.appKey;
    }

    /**
     * <p>
     * The AppKey value.
     * </p>
     * 
     * @param appKey
     *        The AppKey value.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OtaaV10X withAppKey(String appKey) {
        setAppKey(appKey);
        return this;
    }

    /**
     * <p>
     * The AppEUI value. You specify this value when using LoRaWAN versions v1.0.2 or v1.0.3.
     * </p>
     * 
     * @param appEui
     *        The AppEUI value. You specify this value when using LoRaWAN versions v1.0.2 or v1.0.3.
     */

    public void setAppEui(String appEui) {
        this.appEui = appEui;
    }

    /**
     * <p>
     * The AppEUI value. You specify this value when using LoRaWAN versions v1.0.2 or v1.0.3.
     * </p>
     * 
     * @return The AppEUI value. You specify this value when using LoRaWAN versions v1.0.2 or v1.0.3.
     */

    public String getAppEui() {
        return this.appEui;
    }

    /**
     * <p>
     * The AppEUI value. You specify this value when using LoRaWAN versions v1.0.2 or v1.0.3.
     * </p>
     * 
     * @param appEui
     *        The AppEUI value. You specify this value when using LoRaWAN versions v1.0.2 or v1.0.3.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OtaaV10X withAppEui(String appEui) {
        setAppEui(appEui);
        return this;
    }

    /**
     * <p>
     * The JoinEUI value. You specify this value instead of the AppEUI when using LoRaWAN version v1.0.4.
     * </p>
     * 
     * @param joinEui
     *        The JoinEUI value. You specify this value instead of the AppEUI when using LoRaWAN version v1.0.4.
     */

    public void setJoinEui(String joinEui) {
        this.joinEui = joinEui;
    }

    /**
     * <p>
     * The JoinEUI value. You specify this value instead of the AppEUI when using LoRaWAN version v1.0.4.
     * </p>
     * 
     * @return The JoinEUI value. You specify this value instead of the AppEUI when using LoRaWAN version v1.0.4.
     */

    public String getJoinEui() {
        return this.joinEui;
    }

    /**
     * <p>
     * The JoinEUI value. You specify this value instead of the AppEUI when using LoRaWAN version v1.0.4.
     * </p>
     * 
     * @param joinEui
     *        The JoinEUI value. You specify this value instead of the AppEUI when using LoRaWAN version v1.0.4.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OtaaV10X withJoinEui(String joinEui) {
        setJoinEui(joinEui);
        return this;
    }

    /**
     * <p>
     * The GenAppKey value.
     * </p>
     * 
     * @param genAppKey
     *        The GenAppKey value.
     */

    public void setGenAppKey(String genAppKey) {
        this.genAppKey = genAppKey;
    }

    /**
     * <p>
     * The GenAppKey value.
     * </p>
     * 
     * @return The GenAppKey value.
     */

    public String getGenAppKey() {
        return this.genAppKey;
    }

    /**
     * <p>
     * The GenAppKey value.
     * </p>
     * 
     * @param genAppKey
     *        The GenAppKey value.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OtaaV10X withGenAppKey(String genAppKey) {
        setGenAppKey(genAppKey);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAppKey() != null)
            sb.append("AppKey: ").append(getAppKey()).append(",");
        if (getAppEui() != null)
            sb.append("AppEui: ").append(getAppEui()).append(",");
        if (getJoinEui() != null)
            sb.append("JoinEui: ").append(getJoinEui()).append(",");
        if (getGenAppKey() != null)
            sb.append("GenAppKey: ").append(getGenAppKey());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof OtaaV10X == false)
            return false;
        OtaaV10X other = (OtaaV10X) obj;
        if (other.getAppKey() == null ^ this.getAppKey() == null)
            return false;
        if (other.getAppKey() != null && other.getAppKey().equals(this.getAppKey()) == false)
            return false;
        if (other.getAppEui() == null ^ this.getAppEui() == null)
            return false;
        if (other.getAppEui() != null && other.getAppEui().equals(this.getAppEui()) == false)
            return false;
        if (other.getJoinEui() == null ^ this.getJoinEui() == null)
            return false;
        if (other.getJoinEui() != null && other.getJoinEui().equals(this.getJoinEui()) == false)
            return false;
        if (other.getGenAppKey() == null ^ this.getGenAppKey() == null)
            return false;
        if (other.getGenAppKey() != null && other.getGenAppKey().equals(this.getGenAppKey()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAppKey() == null) ? 0 : getAppKey().hashCode());
        hashCode = prime * hashCode + ((getAppEui() == null) ? 0 : getAppEui().hashCode());
        hashCode = prime * hashCode + ((getJoinEui() == null) ? 0 : getJoinEui().hashCode());
        hashCode = prime * hashCode + ((getGenAppKey() == null) ? 0 : getGenAppKey().hashCode());
        return hashCode;
    }

    @Override
    public OtaaV10X clone() {
        try {
            return (OtaaV10X) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.iotwireless.model.transform.OtaaV10XMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
