/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotwireless.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iotwireless.model.CellTowers;
import com.amazonaws.services.iotwireless.model.Gnss;
import com.amazonaws.services.iotwireless.model.Ip;
import com.amazonaws.services.iotwireless.model.WiFiAccessPoint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class GetPositionEstimateRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<WiFiAccessPoint> wiFiAccessPoints;
    private CellTowers cellTowers;
    private Ip ip;
    private Gnss gnss;
    private Date timestamp;

    public List<WiFiAccessPoint> getWiFiAccessPoints() {
        return this.wiFiAccessPoints;
    }

    public void setWiFiAccessPoints(Collection<WiFiAccessPoint> wiFiAccessPoints) {
        if (wiFiAccessPoints == null) {
            this.wiFiAccessPoints = null;
            return;
        }
        this.wiFiAccessPoints = new ArrayList<WiFiAccessPoint>(wiFiAccessPoints);
    }

    public GetPositionEstimateRequest withWiFiAccessPoints(WiFiAccessPoint ... wiFiAccessPoints) {
        if (this.wiFiAccessPoints == null) {
            this.setWiFiAccessPoints(new ArrayList<WiFiAccessPoint>(wiFiAccessPoints.length));
        }
        for (WiFiAccessPoint ele : wiFiAccessPoints) {
            this.wiFiAccessPoints.add(ele);
        }
        return this;
    }

    public GetPositionEstimateRequest withWiFiAccessPoints(Collection<WiFiAccessPoint> wiFiAccessPoints) {
        this.setWiFiAccessPoints(wiFiAccessPoints);
        return this;
    }

    public void setCellTowers(CellTowers cellTowers) {
        this.cellTowers = cellTowers;
    }

    public CellTowers getCellTowers() {
        return this.cellTowers;
    }

    public GetPositionEstimateRequest withCellTowers(CellTowers cellTowers) {
        this.setCellTowers(cellTowers);
        return this;
    }

    public void setIp(Ip ip) {
        this.ip = ip;
    }

    public Ip getIp() {
        return this.ip;
    }

    public GetPositionEstimateRequest withIp(Ip ip) {
        this.setIp(ip);
        return this;
    }

    public void setGnss(Gnss gnss) {
        this.gnss = gnss;
    }

    public Gnss getGnss() {
        return this.gnss;
    }

    public GetPositionEstimateRequest withGnss(Gnss gnss) {
        this.setGnss(gnss);
        return this;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public GetPositionEstimateRequest withTimestamp(Date timestamp) {
        this.setTimestamp(timestamp);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWiFiAccessPoints() != null) {
            sb.append("WiFiAccessPoints: ").append(this.getWiFiAccessPoints()).append(",");
        }
        if (this.getCellTowers() != null) {
            sb.append("CellTowers: ").append(this.getCellTowers()).append(",");
        }
        if (this.getIp() != null) {
            sb.append("Ip: ").append(this.getIp()).append(",");
        }
        if (this.getGnss() != null) {
            sb.append("Gnss: ").append(this.getGnss()).append(",");
        }
        if (this.getTimestamp() != null) {
            sb.append("Timestamp: ").append(this.getTimestamp());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPositionEstimateRequest)) {
            return false;
        }
        GetPositionEstimateRequest other = (GetPositionEstimateRequest)obj;
        if (other.getWiFiAccessPoints() == null ^ this.getWiFiAccessPoints() == null) {
            return false;
        }
        if (other.getWiFiAccessPoints() != null && !other.getWiFiAccessPoints().equals(this.getWiFiAccessPoints())) {
            return false;
        }
        if (other.getCellTowers() == null ^ this.getCellTowers() == null) {
            return false;
        }
        if (other.getCellTowers() != null && !other.getCellTowers().equals(this.getCellTowers())) {
            return false;
        }
        if (other.getIp() == null ^ this.getIp() == null) {
            return false;
        }
        if (other.getIp() != null && !other.getIp().equals(this.getIp())) {
            return false;
        }
        if (other.getGnss() == null ^ this.getGnss() == null) {
            return false;
        }
        if (other.getGnss() != null && !other.getGnss().equals(this.getGnss())) {
            return false;
        }
        if (other.getTimestamp() == null ^ this.getTimestamp() == null) {
            return false;
        }
        return other.getTimestamp() == null || other.getTimestamp().equals(this.getTimestamp());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWiFiAccessPoints() == null ? 0 : this.getWiFiAccessPoints().hashCode());
        hashCode = 31 * hashCode + (this.getCellTowers() == null ? 0 : this.getCellTowers().hashCode());
        hashCode = 31 * hashCode + (this.getIp() == null ? 0 : this.getIp().hashCode());
        hashCode = 31 * hashCode + (this.getGnss() == null ? 0 : this.getGnss().hashCode());
        hashCode = 31 * hashCode + (this.getTimestamp() == null ? 0 : this.getTimestamp().hashCode());
        return hashCode;
    }

    public GetPositionEstimateRequest clone() {
        return (GetPositionEstimateRequest)super.clone();
    }
}

