/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotwireless.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotwireless.model.transform.BeaconingMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Beaconing
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer dataRate;
    private List<Integer> frequencies;

    public void setDataRate(Integer dataRate) {
        this.dataRate = dataRate;
    }

    public Integer getDataRate() {
        return this.dataRate;
    }

    public Beaconing withDataRate(Integer dataRate) {
        this.setDataRate(dataRate);
        return this;
    }

    public List<Integer> getFrequencies() {
        return this.frequencies;
    }

    public void setFrequencies(Collection<Integer> frequencies) {
        if (frequencies == null) {
            this.frequencies = null;
            return;
        }
        this.frequencies = new ArrayList<Integer>(frequencies);
    }

    public Beaconing withFrequencies(Integer ... frequencies) {
        if (this.frequencies == null) {
            this.setFrequencies(new ArrayList<Integer>(frequencies.length));
        }
        for (Integer ele : frequencies) {
            this.frequencies.add(ele);
        }
        return this;
    }

    public Beaconing withFrequencies(Collection<Integer> frequencies) {
        this.setFrequencies(frequencies);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataRate() != null) {
            sb.append("DataRate: ").append(this.getDataRate()).append(",");
        }
        if (this.getFrequencies() != null) {
            sb.append("Frequencies: ").append(this.getFrequencies());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Beaconing)) {
            return false;
        }
        Beaconing other = (Beaconing)obj;
        if (other.getDataRate() == null ^ this.getDataRate() == null) {
            return false;
        }
        if (other.getDataRate() != null && !other.getDataRate().equals(this.getDataRate())) {
            return false;
        }
        if (other.getFrequencies() == null ^ this.getFrequencies() == null) {
            return false;
        }
        return other.getFrequencies() == null || other.getFrequencies().equals(this.getFrequencies());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataRate() == null ? 0 : this.getDataRate().hashCode());
        hashCode = 31 * hashCode + (this.getFrequencies() == null ? 0 : this.getFrequencies().hashCode());
        return hashCode;
    }

    public Beaconing clone() {
        try {
            return (Beaconing)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BeaconingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

