/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotwireless.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotwireless.model.WirelessMetadata;

@SdkInternalApi
public class WirelessMetadataMarshaller {
    private static final MarshallingInfo<StructuredPojo> LORAWAN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LoRaWAN").build();
    private static final MarshallingInfo<StructuredPojo> SIDEWALK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sidewalk").build();
    private static final WirelessMetadataMarshaller instance = new WirelessMetadataMarshaller();

    public static WirelessMetadataMarshaller getInstance() {
        return instance;
    }

    public void marshall(WirelessMetadata wirelessMetadata, ProtocolMarshaller protocolMarshaller) {
        if (wirelessMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)wirelessMetadata.getLoRaWAN(), LORAWAN_BINDING);
            protocolMarshaller.marshall((Object)wirelessMetadata.getSidewalk(), SIDEWALK_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

