/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iottwinmaker.model.IotTwinMakerSourceConfigurationFilter;
import com.amazonaws.services.iottwinmaker.model.transform.IotTwinMakerSourceConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IotTwinMakerSourceConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String workspace;
    private List<IotTwinMakerSourceConfigurationFilter> filters;

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public IotTwinMakerSourceConfiguration withWorkspace(String workspace) {
        this.setWorkspace(workspace);
        return this;
    }

    public List<IotTwinMakerSourceConfigurationFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<IotTwinMakerSourceConfigurationFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<IotTwinMakerSourceConfigurationFilter>(filters);
    }

    public IotTwinMakerSourceConfiguration withFilters(IotTwinMakerSourceConfigurationFilter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<IotTwinMakerSourceConfigurationFilter>(filters.length));
        }
        for (IotTwinMakerSourceConfigurationFilter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public IotTwinMakerSourceConfiguration withFilters(Collection<IotTwinMakerSourceConfigurationFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWorkspace() != null) {
            sb.append("Workspace: ").append(this.getWorkspace()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotTwinMakerSourceConfiguration)) {
            return false;
        }
        IotTwinMakerSourceConfiguration other = (IotTwinMakerSourceConfiguration)obj;
        if (other.getWorkspace() == null ^ this.getWorkspace() == null) {
            return false;
        }
        if (other.getWorkspace() != null && !other.getWorkspace().equals(this.getWorkspace())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || other.getFilters().equals(this.getFilters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWorkspace() == null ? 0 : this.getWorkspace().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        return hashCode;
    }

    public IotTwinMakerSourceConfiguration clone() {
        try {
            return (IotTwinMakerSourceConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IotTwinMakerSourceConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

