/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iottwinmaker.model.DataValue;
import com.amazonaws.services.iottwinmaker.model.Relationship;
import com.amazonaws.services.iottwinmaker.model.Type;
import com.amazonaws.services.iottwinmaker.model.transform.DataTypeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DataType
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private DataType nestedType;
    private List<DataValue> allowedValues;
    private String unitOfMeasure;
    private Relationship relationship;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public DataType withType(String type) {
        this.setType(type);
        return this;
    }

    public DataType withType(Type type) {
        this.type = type.toString();
        return this;
    }

    public void setNestedType(DataType nestedType) {
        this.nestedType = nestedType;
    }

    public DataType getNestedType() {
        return this.nestedType;
    }

    public DataType withNestedType(DataType nestedType) {
        this.setNestedType(nestedType);
        return this;
    }

    public List<DataValue> getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(Collection<DataValue> allowedValues) {
        if (allowedValues == null) {
            this.allowedValues = null;
            return;
        }
        this.allowedValues = new ArrayList<DataValue>(allowedValues);
    }

    public DataType withAllowedValues(DataValue ... allowedValues) {
        if (this.allowedValues == null) {
            this.setAllowedValues(new ArrayList<DataValue>(allowedValues.length));
        }
        for (DataValue ele : allowedValues) {
            this.allowedValues.add(ele);
        }
        return this;
    }

    public DataType withAllowedValues(Collection<DataValue> allowedValues) {
        this.setAllowedValues(allowedValues);
        return this;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public DataType withUnitOfMeasure(String unitOfMeasure) {
        this.setUnitOfMeasure(unitOfMeasure);
        return this;
    }

    public void setRelationship(Relationship relationship) {
        this.relationship = relationship;
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    public DataType withRelationship(Relationship relationship) {
        this.setRelationship(relationship);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getNestedType() != null) {
            sb.append("NestedType: ").append(this.getNestedType()).append(",");
        }
        if (this.getAllowedValues() != null) {
            sb.append("AllowedValues: ").append(this.getAllowedValues()).append(",");
        }
        if (this.getUnitOfMeasure() != null) {
            sb.append("UnitOfMeasure: ").append(this.getUnitOfMeasure()).append(",");
        }
        if (this.getRelationship() != null) {
            sb.append("Relationship: ").append(this.getRelationship());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataType)) {
            return false;
        }
        DataType other = (DataType)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getNestedType() == null ^ this.getNestedType() == null) {
            return false;
        }
        if (other.getNestedType() != null && !other.getNestedType().equals(this.getNestedType())) {
            return false;
        }
        if (other.getAllowedValues() == null ^ this.getAllowedValues() == null) {
            return false;
        }
        if (other.getAllowedValues() != null && !other.getAllowedValues().equals(this.getAllowedValues())) {
            return false;
        }
        if (other.getUnitOfMeasure() == null ^ this.getUnitOfMeasure() == null) {
            return false;
        }
        if (other.getUnitOfMeasure() != null && !other.getUnitOfMeasure().equals(this.getUnitOfMeasure())) {
            return false;
        }
        if (other.getRelationship() == null ^ this.getRelationship() == null) {
            return false;
        }
        return other.getRelationship() == null || other.getRelationship().equals(this.getRelationship());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getNestedType() == null ? 0 : this.getNestedType().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedValues() == null ? 0 : this.getAllowedValues().hashCode());
        hashCode = 31 * hashCode + (this.getUnitOfMeasure() == null ? 0 : this.getUnitOfMeasure().hashCode());
        hashCode = 31 * hashCode + (this.getRelationship() == null ? 0 : this.getRelationship().hashCode());
        return hashCode;
    }

    public DataType clone() {
        try {
            return (DataType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

