/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iottwinmaker.model.GroupType;
import com.amazonaws.services.iottwinmaker.model.transform.PropertyGroupRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PropertyGroupRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private String groupType;
    private List<String> propertyNames;

    public void setGroupType(String groupType) {
        this.groupType = groupType;
    }

    public String getGroupType() {
        return this.groupType;
    }

    public PropertyGroupRequest withGroupType(String groupType) {
        this.setGroupType(groupType);
        return this;
    }

    public PropertyGroupRequest withGroupType(GroupType groupType) {
        this.groupType = groupType.toString();
        return this;
    }

    public List<String> getPropertyNames() {
        return this.propertyNames;
    }

    public void setPropertyNames(Collection<String> propertyNames) {
        if (propertyNames == null) {
            this.propertyNames = null;
            return;
        }
        this.propertyNames = new ArrayList<String>(propertyNames);
    }

    public PropertyGroupRequest withPropertyNames(String ... propertyNames) {
        if (this.propertyNames == null) {
            this.setPropertyNames(new ArrayList<String>(propertyNames.length));
        }
        for (String ele : propertyNames) {
            this.propertyNames.add(ele);
        }
        return this;
    }

    public PropertyGroupRequest withPropertyNames(Collection<String> propertyNames) {
        this.setPropertyNames(propertyNames);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroupType() != null) {
            sb.append("GroupType: ").append(this.getGroupType()).append(",");
        }
        if (this.getPropertyNames() != null) {
            sb.append("PropertyNames: ").append(this.getPropertyNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyGroupRequest)) {
            return false;
        }
        PropertyGroupRequest other = (PropertyGroupRequest)obj;
        if (other.getGroupType() == null ^ this.getGroupType() == null) {
            return false;
        }
        if (other.getGroupType() != null && !other.getGroupType().equals(this.getGroupType())) {
            return false;
        }
        if (other.getPropertyNames() == null ^ this.getPropertyNames() == null) {
            return false;
        }
        return other.getPropertyNames() == null || other.getPropertyNames().equals(this.getPropertyNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroupType() == null ? 0 : this.getGroupType().hashCode());
        hashCode = 31 * hashCode + (this.getPropertyNames() == null ? 0 : this.getPropertyNames().hashCode());
        return hashCode;
    }

    public PropertyGroupRequest clone() {
        try {
            return (PropertyGroupRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PropertyGroupRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

