/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iottwinmaker.model.EntityPropertyReference;
import com.amazonaws.services.iottwinmaker.model.PropertyValue;
import com.amazonaws.services.iottwinmaker.model.transform.PropertyValueEntryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PropertyValueEntry
implements Serializable,
Cloneable,
StructuredPojo {
    private EntityPropertyReference entityPropertyReference;
    private List<PropertyValue> propertyValues;

    public void setEntityPropertyReference(EntityPropertyReference entityPropertyReference) {
        this.entityPropertyReference = entityPropertyReference;
    }

    public EntityPropertyReference getEntityPropertyReference() {
        return this.entityPropertyReference;
    }

    public PropertyValueEntry withEntityPropertyReference(EntityPropertyReference entityPropertyReference) {
        this.setEntityPropertyReference(entityPropertyReference);
        return this;
    }

    public List<PropertyValue> getPropertyValues() {
        return this.propertyValues;
    }

    public void setPropertyValues(Collection<PropertyValue> propertyValues) {
        if (propertyValues == null) {
            this.propertyValues = null;
            return;
        }
        this.propertyValues = new ArrayList<PropertyValue>(propertyValues);
    }

    public PropertyValueEntry withPropertyValues(PropertyValue ... propertyValues) {
        if (this.propertyValues == null) {
            this.setPropertyValues(new ArrayList<PropertyValue>(propertyValues.length));
        }
        for (PropertyValue ele : propertyValues) {
            this.propertyValues.add(ele);
        }
        return this;
    }

    public PropertyValueEntry withPropertyValues(Collection<PropertyValue> propertyValues) {
        this.setPropertyValues(propertyValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEntityPropertyReference() != null) {
            sb.append("EntityPropertyReference: ").append(this.getEntityPropertyReference()).append(",");
        }
        if (this.getPropertyValues() != null) {
            sb.append("PropertyValues: ").append(this.getPropertyValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyValueEntry)) {
            return false;
        }
        PropertyValueEntry other = (PropertyValueEntry)obj;
        if (other.getEntityPropertyReference() == null ^ this.getEntityPropertyReference() == null) {
            return false;
        }
        if (other.getEntityPropertyReference() != null && !other.getEntityPropertyReference().equals(this.getEntityPropertyReference())) {
            return false;
        }
        if (other.getPropertyValues() == null ^ this.getPropertyValues() == null) {
            return false;
        }
        return other.getPropertyValues() == null || other.getPropertyValues().equals(this.getPropertyValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEntityPropertyReference() == null ? 0 : this.getEntityPropertyReference().hashCode());
        hashCode = 31 * hashCode + (this.getPropertyValues() == null ? 0 : this.getPropertyValues().hashCode());
        return hashCode;
    }

    public PropertyValueEntry clone() {
        try {
            return (PropertyValueEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PropertyValueEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

