/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iottwinmaker.model.PropertyRequest;
import com.amazonaws.services.iottwinmaker.model.transform.ComponentRequestMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ComponentRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private String componentTypeId;
    private String description;
    private Map<String, PropertyRequest> properties;

    public void setComponentTypeId(String componentTypeId) {
        this.componentTypeId = componentTypeId;
    }

    public String getComponentTypeId() {
        return this.componentTypeId;
    }

    public ComponentRequest withComponentTypeId(String componentTypeId) {
        this.setComponentTypeId(componentTypeId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ComponentRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, PropertyRequest> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, PropertyRequest> properties) {
        this.properties = properties;
    }

    public ComponentRequest withProperties(Map<String, PropertyRequest> properties) {
        this.setProperties(properties);
        return this;
    }

    public ComponentRequest addPropertiesEntry(String key, PropertyRequest value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, PropertyRequest>();
        }
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.properties.put(key, value);
        return this;
    }

    public ComponentRequest clearPropertiesEntries() {
        this.properties = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComponentTypeId() != null) {
            sb.append("ComponentTypeId: ").append(this.getComponentTypeId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentRequest)) {
            return false;
        }
        ComponentRequest other = (ComponentRequest)obj;
        if (other.getComponentTypeId() == null ^ this.getComponentTypeId() == null) {
            return false;
        }
        if (other.getComponentTypeId() != null && !other.getComponentTypeId().equals(this.getComponentTypeId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        return other.getProperties() == null || other.getProperties().equals(this.getProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComponentTypeId() == null ? 0 : this.getComponentTypeId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        return hashCode;
    }

    public ComponentRequest clone() {
        try {
            return (ComponentRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComponentRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

