/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsitewise.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iotsitewise.model.Image;
import java.util.Date;

@SdkInternalApi
public class ImageMarshaller {
    private static final MarshallingInfo<String> LOCATIONURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("locationUrl").build();
    private static final MarshallingInfo<Date> LASTUPDATEDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdateDate").timestampFormat("unixTimestamp").build();
    private static final ImageMarshaller instance = new ImageMarshaller();

    public static ImageMarshaller getInstance() {
        return instance;
    }

    public void marshall(Image image, ProtocolMarshaller protocolMarshaller) {
        if (image == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)image.getLocationUrl(), LOCATIONURL_BINDING);
            protocolMarshaller.marshall((Object)image.getLastUpdateDate(), LASTUPDATEDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

