/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotfleetwise.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotfleetwise.model.MessageSignal;

@SdkInternalApi
public class MessageSignalMarshaller {
    private static final MarshallingInfo<String> TOPICNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("topicName").build();
    private static final MarshallingInfo<StructuredPojo> STRUCTUREDMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("structuredMessage").build();
    private static final MessageSignalMarshaller instance = new MessageSignalMarshaller();

    public static MessageSignalMarshaller getInstance() {
        return instance;
    }

    public void marshall(MessageSignal messageSignal, ProtocolMarshaller protocolMarshaller) {
        if (messageSignal == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)messageSignal.getTopicName(), TOPICNAME_BINDING);
            protocolMarshaller.marshall((Object)messageSignal.getStructuredMessage(), STRUCTUREDMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

