/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotfleethub;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.iotfleethub.AWSIoTFleetHubAsync;
import com.amazonaws.services.iotfleethub.AWSIoTFleetHubAsyncClientBuilder;
import com.amazonaws.services.iotfleethub.AWSIoTFleetHubClient;
import com.amazonaws.services.iotfleethub.model.CreateApplicationRequest;
import com.amazonaws.services.iotfleethub.model.CreateApplicationResult;
import com.amazonaws.services.iotfleethub.model.DeleteApplicationRequest;
import com.amazonaws.services.iotfleethub.model.DeleteApplicationResult;
import com.amazonaws.services.iotfleethub.model.DescribeApplicationRequest;
import com.amazonaws.services.iotfleethub.model.DescribeApplicationResult;
import com.amazonaws.services.iotfleethub.model.ListApplicationsRequest;
import com.amazonaws.services.iotfleethub.model.ListApplicationsResult;
import com.amazonaws.services.iotfleethub.model.ListTagsForResourceRequest;
import com.amazonaws.services.iotfleethub.model.ListTagsForResourceResult;
import com.amazonaws.services.iotfleethub.model.TagResourceRequest;
import com.amazonaws.services.iotfleethub.model.TagResourceResult;
import com.amazonaws.services.iotfleethub.model.UntagResourceRequest;
import com.amazonaws.services.iotfleethub.model.UntagResourceResult;
import com.amazonaws.services.iotfleethub.model.UpdateApplicationRequest;
import com.amazonaws.services.iotfleethub.model.UpdateApplicationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSIoTFleetHubAsyncClient
extends AWSIoTFleetHubClient
implements AWSIoTFleetHubAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSIoTFleetHubAsyncClientBuilder asyncBuilder() {
        return AWSIoTFleetHubAsyncClientBuilder.standard();
    }

    AWSIoTFleetHubAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSIoTFleetHubAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(CreateApplicationRequest request) {
        return this.createApplicationAsync(request, null);
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(CreateApplicationRequest request, final AsyncHandler<CreateApplicationRequest, CreateApplicationResult> asyncHandler) {
        final CreateApplicationRequest finalRequest = (CreateApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateApplicationResult>(){

            @Override
            public CreateApplicationResult call() throws Exception {
                CreateApplicationResult result = null;
                try {
                    result = AWSIoTFleetHubAsyncClient.this.executeCreateApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteApplicationResult> deleteApplicationAsync(DeleteApplicationRequest request) {
        return this.deleteApplicationAsync(request, null);
    }

    @Override
    public Future<DeleteApplicationResult> deleteApplicationAsync(DeleteApplicationRequest request, final AsyncHandler<DeleteApplicationRequest, DeleteApplicationResult> asyncHandler) {
        final DeleteApplicationRequest finalRequest = (DeleteApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteApplicationResult>(){

            @Override
            public DeleteApplicationResult call() throws Exception {
                DeleteApplicationResult result = null;
                try {
                    result = AWSIoTFleetHubAsyncClient.this.executeDeleteApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeApplicationResult> describeApplicationAsync(DescribeApplicationRequest request) {
        return this.describeApplicationAsync(request, null);
    }

    @Override
    public Future<DescribeApplicationResult> describeApplicationAsync(DescribeApplicationRequest request, final AsyncHandler<DescribeApplicationRequest, DescribeApplicationResult> asyncHandler) {
        final DescribeApplicationRequest finalRequest = (DescribeApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeApplicationResult>(){

            @Override
            public DescribeApplicationResult call() throws Exception {
                DescribeApplicationResult result = null;
                try {
                    result = AWSIoTFleetHubAsyncClient.this.executeDescribeApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListApplicationsResult> listApplicationsAsync(ListApplicationsRequest request) {
        return this.listApplicationsAsync(request, null);
    }

    @Override
    public Future<ListApplicationsResult> listApplicationsAsync(ListApplicationsRequest request, final AsyncHandler<ListApplicationsRequest, ListApplicationsResult> asyncHandler) {
        final ListApplicationsRequest finalRequest = (ListApplicationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListApplicationsResult>(){

            @Override
            public ListApplicationsResult call() throws Exception {
                ListApplicationsResult result = null;
                try {
                    result = AWSIoTFleetHubAsyncClient.this.executeListApplications(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSIoTFleetHubAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSIoTFleetHubAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSIoTFleetHubAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateApplicationResult> updateApplicationAsync(UpdateApplicationRequest request) {
        return this.updateApplicationAsync(request, null);
    }

    @Override
    public Future<UpdateApplicationResult> updateApplicationAsync(UpdateApplicationRequest request, final AsyncHandler<UpdateApplicationRequest, UpdateApplicationResult> asyncHandler) {
        final UpdateApplicationRequest finalRequest = (UpdateApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateApplicationResult>(){

            @Override
            public UpdateApplicationResult call() throws Exception {
                UpdateApplicationResult result = null;
                try {
                    result = AWSIoTFleetHubAsyncClient.this.executeUpdateApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

