/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotevents;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.iotevents.AWSIoTEventsAsync;
import com.amazonaws.services.iotevents.AWSIoTEventsAsyncClientBuilder;
import com.amazonaws.services.iotevents.AWSIoTEventsClient;
import com.amazonaws.services.iotevents.model.CreateDetectorModelRequest;
import com.amazonaws.services.iotevents.model.CreateDetectorModelResult;
import com.amazonaws.services.iotevents.model.CreateInputRequest;
import com.amazonaws.services.iotevents.model.CreateInputResult;
import com.amazonaws.services.iotevents.model.DeleteDetectorModelRequest;
import com.amazonaws.services.iotevents.model.DeleteDetectorModelResult;
import com.amazonaws.services.iotevents.model.DeleteInputRequest;
import com.amazonaws.services.iotevents.model.DeleteInputResult;
import com.amazonaws.services.iotevents.model.DescribeDetectorModelRequest;
import com.amazonaws.services.iotevents.model.DescribeDetectorModelResult;
import com.amazonaws.services.iotevents.model.DescribeInputRequest;
import com.amazonaws.services.iotevents.model.DescribeInputResult;
import com.amazonaws.services.iotevents.model.DescribeLoggingOptionsRequest;
import com.amazonaws.services.iotevents.model.DescribeLoggingOptionsResult;
import com.amazonaws.services.iotevents.model.ListDetectorModelVersionsRequest;
import com.amazonaws.services.iotevents.model.ListDetectorModelVersionsResult;
import com.amazonaws.services.iotevents.model.ListDetectorModelsRequest;
import com.amazonaws.services.iotevents.model.ListDetectorModelsResult;
import com.amazonaws.services.iotevents.model.ListInputsRequest;
import com.amazonaws.services.iotevents.model.ListInputsResult;
import com.amazonaws.services.iotevents.model.ListTagsForResourceRequest;
import com.amazonaws.services.iotevents.model.ListTagsForResourceResult;
import com.amazonaws.services.iotevents.model.PutLoggingOptionsRequest;
import com.amazonaws.services.iotevents.model.PutLoggingOptionsResult;
import com.amazonaws.services.iotevents.model.TagResourceRequest;
import com.amazonaws.services.iotevents.model.TagResourceResult;
import com.amazonaws.services.iotevents.model.UntagResourceRequest;
import com.amazonaws.services.iotevents.model.UntagResourceResult;
import com.amazonaws.services.iotevents.model.UpdateDetectorModelRequest;
import com.amazonaws.services.iotevents.model.UpdateDetectorModelResult;
import com.amazonaws.services.iotevents.model.UpdateInputRequest;
import com.amazonaws.services.iotevents.model.UpdateInputResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSIoTEventsAsyncClient
extends AWSIoTEventsClient
implements AWSIoTEventsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSIoTEventsAsyncClientBuilder asyncBuilder() {
        return AWSIoTEventsAsyncClientBuilder.standard();
    }

    AWSIoTEventsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSIoTEventsAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateDetectorModelResult> createDetectorModelAsync(CreateDetectorModelRequest request) {
        return this.createDetectorModelAsync(request, null);
    }

    @Override
    public Future<CreateDetectorModelResult> createDetectorModelAsync(CreateDetectorModelRequest request, final AsyncHandler<CreateDetectorModelRequest, CreateDetectorModelResult> asyncHandler) {
        final CreateDetectorModelRequest finalRequest = (CreateDetectorModelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDetectorModelResult>(){

            @Override
            public CreateDetectorModelResult call() throws Exception {
                CreateDetectorModelResult result = null;
                try {
                    result = AWSIoTEventsAsyncClient.this.executeCreateDetectorModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateInputResult> createInputAsync(CreateInputRequest request) {
        return this.createInputAsync(request, null);
    }

    @Override
    public Future<CreateInputResult> createInputAsync(CreateInputRequest request, final AsyncHandler<CreateInputRequest, CreateInputResult> asyncHandler) {
        final CreateInputRequest finalRequest = (CreateInputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateInputResult>(){

            @Override
            public CreateInputResult call() throws Exception {
                CreateInputResult result = null;
                try {
                    result = AWSIoTEventsAsyncClient.this.executeCreateInput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDetectorModelResult> deleteDetectorModelAsync(DeleteDetectorModelRequest request) {
        return this.deleteDetectorModelAsync(request, null);
    }

    @Override
    public Future<DeleteDetectorModelResult> deleteDetectorModelAsync(DeleteDetectorModelRequest request, final AsyncHandler<DeleteDetectorModelRequest, DeleteDetectorModelResult> asyncHandler) {
        final DeleteDetectorModelRequest finalRequest = (DeleteDetectorModelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDetectorModelResult>(){

            @Override
            public DeleteDetectorModelResult call() throws Exception {
                DeleteDetectorModelResult result = null;
                try {
                    result = AWSIoTEventsAsyncClient.this.executeDeleteDetectorModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteInputResult> deleteInputAsync(DeleteInputRequest request) {
        return this.deleteInputAsync(request, null);
    }

    @Override
    public Future<DeleteInputResult> deleteInputAsync(DeleteInputRequest request, final AsyncHandler<DeleteInputRequest, DeleteInputResult> asyncHandler) {
        final DeleteInputRequest finalRequest = (DeleteInputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteInputResult>(){

            @Override
            public DeleteInputResult call() throws Exception {
                DeleteInputResult result = null;
                try {
                    result = AWSIoTEventsAsyncClient.this.executeDeleteInput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDetectorModelResult> describeDetectorModelAsync(DescribeDetectorModelRequest request) {
        return this.describeDetectorModelAsync(request, null);
    }

    @Override
    public Future<DescribeDetectorModelResult> describeDetectorModelAsync(DescribeDetectorModelRequest request, final AsyncHandler<DescribeDetectorModelRequest, DescribeDetectorModelResult> asyncHandler) {
        final DescribeDetectorModelRequest finalRequest = (DescribeDetectorModelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDetectorModelResult>(){

            @Override
            public DescribeDetectorModelResult call() throws Exception {
                DescribeDetectorModelResult result = null;
                try {
                    result = AWSIoTEventsAsyncClient.this.executeDescribeDetectorModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInputResult> describeInputAsync(DescribeInputRequest request) {
        return this.describeInputAsync(request, null);
    }

    @Override
    public Future<DescribeInputResult> describeInputAsync(DescribeInputRequest request, final AsyncHandler<DescribeInputRequest, DescribeInputResult> asyncHandler) {
        final DescribeInputRequest finalRequest = (DescribeInputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeInputResult>(){

            @Override
            public DescribeInputResult call() throws Exception {
                DescribeInputResult result = null;
                try {
                    result = AWSIoTEventsAsyncClient.this.executeDescribeInput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLoggingOptionsResult> describeLoggingOptionsAsync(DescribeLoggingOptionsRequest request) {
        return this.describeLoggingOptionsAsync(request, null);
    }

    @Override
    public Future<DescribeLoggingOptionsResult> describeLoggingOptionsAsync(DescribeLoggingOptionsRequest request, final AsyncHandler<DescribeLoggingOptionsRequest, DescribeLoggingOptionsResult> asyncHandler) {
        final DescribeLoggingOptionsRequest finalRequest = (DescribeLoggingOptionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeLoggingOptionsResult>(){

            @Override
            public DescribeLoggingOptionsResult call() throws Exception {
                DescribeLoggingOptionsResult result = null;
                try {
                    result = AWSIoTEventsAsyncClient.this.executeDescribeLoggingOptions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDetectorModelVersionsResult> listDetectorModelVersionsAsync(ListDetectorModelVersionsRequest request) {
        return this.listDetectorModelVersionsAsync(request, null);
    }

    @Override
    public Future<ListDetectorModelVersionsResult> listDetectorModelVersionsAsync(ListDetectorModelVersionsRequest request, final AsyncHandler<ListDetectorModelVersionsRequest, ListDetectorModelVersionsResult> asyncHandler) {
        final ListDetectorModelVersionsRequest finalRequest = (ListDetectorModelVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDetectorModelVersionsResult>(){

            @Override
            public ListDetectorModelVersionsResult call() throws Exception {
                ListDetectorModelVersionsResult result = null;
                try {
                    result = AWSIoTEventsAsyncClient.this.executeListDetectorModelVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDetectorModelsResult> listDetectorModelsAsync(ListDetectorModelsRequest request) {
        return this.listDetectorModelsAsync(request, null);
    }

    @Override
    public Future<ListDetectorModelsResult> listDetectorModelsAsync(ListDetectorModelsRequest request, final AsyncHandler<ListDetectorModelsRequest, ListDetectorModelsResult> asyncHandler) {
        final ListDetectorModelsRequest finalRequest = (ListDetectorModelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDetectorModelsResult>(){

            @Override
            public ListDetectorModelsResult call() throws Exception {
                ListDetectorModelsResult result = null;
                try {
                    result = AWSIoTEventsAsyncClient.this.executeListDetectorModels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInputsResult> listInputsAsync(ListInputsRequest request) {
        return this.listInputsAsync(request, null);
    }

    @Override
    public Future<ListInputsResult> listInputsAsync(ListInputsRequest request, final AsyncHandler<ListInputsRequest, ListInputsResult> asyncHandler) {
        final ListInputsRequest finalRequest = (ListInputsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListInputsResult>(){

            @Override
            public ListInputsResult call() throws Exception {
                ListInputsResult result = null;
                try {
                    result = AWSIoTEventsAsyncClient.this.executeListInputs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSIoTEventsAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutLoggingOptionsResult> putLoggingOptionsAsync(PutLoggingOptionsRequest request) {
        return this.putLoggingOptionsAsync(request, null);
    }

    @Override
    public Future<PutLoggingOptionsResult> putLoggingOptionsAsync(PutLoggingOptionsRequest request, final AsyncHandler<PutLoggingOptionsRequest, PutLoggingOptionsResult> asyncHandler) {
        final PutLoggingOptionsRequest finalRequest = (PutLoggingOptionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutLoggingOptionsResult>(){

            @Override
            public PutLoggingOptionsResult call() throws Exception {
                PutLoggingOptionsResult result = null;
                try {
                    result = AWSIoTEventsAsyncClient.this.executePutLoggingOptions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSIoTEventsAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSIoTEventsAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDetectorModelResult> updateDetectorModelAsync(UpdateDetectorModelRequest request) {
        return this.updateDetectorModelAsync(request, null);
    }

    @Override
    public Future<UpdateDetectorModelResult> updateDetectorModelAsync(UpdateDetectorModelRequest request, final AsyncHandler<UpdateDetectorModelRequest, UpdateDetectorModelResult> asyncHandler) {
        final UpdateDetectorModelRequest finalRequest = (UpdateDetectorModelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDetectorModelResult>(){

            @Override
            public UpdateDetectorModelResult call() throws Exception {
                UpdateDetectorModelResult result = null;
                try {
                    result = AWSIoTEventsAsyncClient.this.executeUpdateDetectorModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateInputResult> updateInputAsync(UpdateInputRequest request) {
        return this.updateInputAsync(request, null);
    }

    @Override
    public Future<UpdateInputResult> updateInputAsync(UpdateInputRequest request, final AsyncHandler<UpdateInputRequest, UpdateInputResult> asyncHandler) {
        final UpdateInputRequest finalRequest = (UpdateInputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateInputResult>(){

            @Override
            public UpdateInputResult call() throws Exception {
                UpdateInputResult result = null;
                try {
                    result = AWSIoTEventsAsyncClient.this.executeUpdateInput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

