/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdeviceadvisor;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iotdeviceadvisor.AWSIoTDeviceAdvisor;
import com.amazonaws.services.iotdeviceadvisor.AWSIoTDeviceAdvisorClientBuilder;
import com.amazonaws.services.iotdeviceadvisor.model.AWSIoTDeviceAdvisorException;
import com.amazonaws.services.iotdeviceadvisor.model.CreateSuiteDefinitionRequest;
import com.amazonaws.services.iotdeviceadvisor.model.CreateSuiteDefinitionResult;
import com.amazonaws.services.iotdeviceadvisor.model.DeleteSuiteDefinitionRequest;
import com.amazonaws.services.iotdeviceadvisor.model.DeleteSuiteDefinitionResult;
import com.amazonaws.services.iotdeviceadvisor.model.GetSuiteDefinitionRequest;
import com.amazonaws.services.iotdeviceadvisor.model.GetSuiteDefinitionResult;
import com.amazonaws.services.iotdeviceadvisor.model.GetSuiteRunReportRequest;
import com.amazonaws.services.iotdeviceadvisor.model.GetSuiteRunReportResult;
import com.amazonaws.services.iotdeviceadvisor.model.GetSuiteRunRequest;
import com.amazonaws.services.iotdeviceadvisor.model.GetSuiteRunResult;
import com.amazonaws.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest;
import com.amazonaws.services.iotdeviceadvisor.model.ListSuiteDefinitionsResult;
import com.amazonaws.services.iotdeviceadvisor.model.ListSuiteRunsRequest;
import com.amazonaws.services.iotdeviceadvisor.model.ListSuiteRunsResult;
import com.amazonaws.services.iotdeviceadvisor.model.ListTagsForResourceRequest;
import com.amazonaws.services.iotdeviceadvisor.model.ListTagsForResourceResult;
import com.amazonaws.services.iotdeviceadvisor.model.ListTestCasesRequest;
import com.amazonaws.services.iotdeviceadvisor.model.ListTestCasesResult;
import com.amazonaws.services.iotdeviceadvisor.model.StartSuiteRunRequest;
import com.amazonaws.services.iotdeviceadvisor.model.StartSuiteRunResult;
import com.amazonaws.services.iotdeviceadvisor.model.TagResourceRequest;
import com.amazonaws.services.iotdeviceadvisor.model.TagResourceResult;
import com.amazonaws.services.iotdeviceadvisor.model.UntagResourceRequest;
import com.amazonaws.services.iotdeviceadvisor.model.UntagResourceResult;
import com.amazonaws.services.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest;
import com.amazonaws.services.iotdeviceadvisor.model.UpdateSuiteDefinitionResult;
import com.amazonaws.services.iotdeviceadvisor.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.CreateSuiteDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.CreateSuiteDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.DeleteSuiteDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.DeleteSuiteDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.GetSuiteDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.GetSuiteDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.GetSuiteRunReportRequestProtocolMarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.GetSuiteRunReportResultJsonUnmarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.GetSuiteRunRequestProtocolMarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.GetSuiteRunResultJsonUnmarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.ListSuiteDefinitionsRequestProtocolMarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.ListSuiteDefinitionsResultJsonUnmarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.ListSuiteRunsRequestProtocolMarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.ListSuiteRunsResultJsonUnmarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.ListTestCasesRequestProtocolMarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.ListTestCasesResultJsonUnmarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.StartSuiteRunRequestProtocolMarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.StartSuiteRunResultJsonUnmarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.UpdateSuiteDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.UpdateSuiteDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.iotdeviceadvisor.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSIoTDeviceAdvisorClient
extends AmazonWebServiceClient
implements AWSIoTDeviceAdvisor {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSIoTDeviceAdvisor.class);
    private static final String DEFAULT_SIGNING_NAME = "iotdeviceadvisor";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSIoTDeviceAdvisorException.class));

    public static AWSIoTDeviceAdvisorClientBuilder builder() {
        return AWSIoTDeviceAdvisorClientBuilder.standard();
    }

    AWSIoTDeviceAdvisorClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSIoTDeviceAdvisorClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("api.iotdeviceadvisor");
        this.setEndpoint("api.iotdeviceadvisor.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/iotdeviceadvisor/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/iotdeviceadvisor/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateSuiteDefinitionResult createSuiteDefinition(CreateSuiteDefinitionRequest request) {
        request = (CreateSuiteDefinitionRequest)this.beforeClientExecution(request);
        return this.executeCreateSuiteDefinition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateSuiteDefinitionResult executeCreateSuiteDefinition(CreateSuiteDefinitionRequest createSuiteDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSuiteDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSuiteDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSuiteDefinitionRequestProtocolMarshaller(protocolFactory).marshall((CreateSuiteDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createSuiteDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IotDeviceAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateSuiteDefinition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSuiteDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateSuiteDefinitionResult createSuiteDefinitionResult = (CreateSuiteDefinitionResult)response.getAwsResponse();
            return createSuiteDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSuiteDefinitionResult deleteSuiteDefinition(DeleteSuiteDefinitionRequest request) {
        request = (DeleteSuiteDefinitionRequest)this.beforeClientExecution(request);
        return this.executeDeleteSuiteDefinition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSuiteDefinitionResult executeDeleteSuiteDefinition(DeleteSuiteDefinitionRequest deleteSuiteDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSuiteDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSuiteDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSuiteDefinitionRequestProtocolMarshaller(protocolFactory).marshall((DeleteSuiteDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSuiteDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IotDeviceAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSuiteDefinition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSuiteDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSuiteDefinitionResult deleteSuiteDefinitionResult = (DeleteSuiteDefinitionResult)response.getAwsResponse();
            return deleteSuiteDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSuiteDefinitionResult getSuiteDefinition(GetSuiteDefinitionRequest request) {
        request = (GetSuiteDefinitionRequest)this.beforeClientExecution(request);
        return this.executeGetSuiteDefinition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSuiteDefinitionResult executeGetSuiteDefinition(GetSuiteDefinitionRequest getSuiteDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSuiteDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSuiteDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSuiteDefinitionRequestProtocolMarshaller(protocolFactory).marshall((GetSuiteDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSuiteDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IotDeviceAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSuiteDefinition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSuiteDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSuiteDefinitionResult getSuiteDefinitionResult = (GetSuiteDefinitionResult)response.getAwsResponse();
            return getSuiteDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSuiteRunResult getSuiteRun(GetSuiteRunRequest request) {
        request = (GetSuiteRunRequest)this.beforeClientExecution(request);
        return this.executeGetSuiteRun(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSuiteRunResult executeGetSuiteRun(GetSuiteRunRequest getSuiteRunRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSuiteRunRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSuiteRunRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSuiteRunRequestProtocolMarshaller(protocolFactory).marshall((GetSuiteRunRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSuiteRunRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IotDeviceAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSuiteRun");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSuiteRunResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSuiteRunResult getSuiteRunResult = (GetSuiteRunResult)response.getAwsResponse();
            return getSuiteRunResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSuiteRunReportResult getSuiteRunReport(GetSuiteRunReportRequest request) {
        request = (GetSuiteRunReportRequest)this.beforeClientExecution(request);
        return this.executeGetSuiteRunReport(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSuiteRunReportResult executeGetSuiteRunReport(GetSuiteRunReportRequest getSuiteRunReportRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSuiteRunReportRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSuiteRunReportRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSuiteRunReportRequestProtocolMarshaller(protocolFactory).marshall((GetSuiteRunReportRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSuiteRunReportRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IotDeviceAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSuiteRunReport");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSuiteRunReportResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSuiteRunReportResult getSuiteRunReportResult = (GetSuiteRunReportResult)response.getAwsResponse();
            return getSuiteRunReportResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSuiteDefinitionsResult listSuiteDefinitions(ListSuiteDefinitionsRequest request) {
        request = (ListSuiteDefinitionsRequest)this.beforeClientExecution(request);
        return this.executeListSuiteDefinitions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSuiteDefinitionsResult executeListSuiteDefinitions(ListSuiteDefinitionsRequest listSuiteDefinitionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSuiteDefinitionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSuiteDefinitionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSuiteDefinitionsRequestProtocolMarshaller(protocolFactory).marshall((ListSuiteDefinitionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSuiteDefinitionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IotDeviceAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSuiteDefinitions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSuiteDefinitionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSuiteDefinitionsResult listSuiteDefinitionsResult = (ListSuiteDefinitionsResult)response.getAwsResponse();
            return listSuiteDefinitionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSuiteRunsResult listSuiteRuns(ListSuiteRunsRequest request) {
        request = (ListSuiteRunsRequest)this.beforeClientExecution(request);
        return this.executeListSuiteRuns(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSuiteRunsResult executeListSuiteRuns(ListSuiteRunsRequest listSuiteRunsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSuiteRunsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSuiteRunsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSuiteRunsRequestProtocolMarshaller(protocolFactory).marshall((ListSuiteRunsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSuiteRunsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IotDeviceAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSuiteRuns");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSuiteRunsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSuiteRunsResult listSuiteRunsResult = (ListSuiteRunsResult)response.getAwsResponse();
            return listSuiteRunsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IotDeviceAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTestCasesResult listTestCases(ListTestCasesRequest request) {
        request = (ListTestCasesRequest)this.beforeClientExecution(request);
        return this.executeListTestCases(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTestCasesResult executeListTestCases(ListTestCasesRequest listTestCasesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTestCasesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTestCasesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTestCasesRequestProtocolMarshaller(protocolFactory).marshall((ListTestCasesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTestCasesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IotDeviceAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTestCases");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTestCasesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTestCasesResult listTestCasesResult = (ListTestCasesResult)response.getAwsResponse();
            return listTestCasesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartSuiteRunResult startSuiteRun(StartSuiteRunRequest request) {
        request = (StartSuiteRunRequest)this.beforeClientExecution(request);
        return this.executeStartSuiteRun(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartSuiteRunResult executeStartSuiteRun(StartSuiteRunRequest startSuiteRunRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startSuiteRunRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartSuiteRunRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartSuiteRunRequestProtocolMarshaller(protocolFactory).marshall((StartSuiteRunRequest)super.beforeMarshalling((AmazonWebServiceRequest)startSuiteRunRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IotDeviceAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartSuiteRun");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartSuiteRunResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartSuiteRunResult startSuiteRunResult = (StartSuiteRunResult)response.getAwsResponse();
            return startSuiteRunResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IotDeviceAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IotDeviceAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateSuiteDefinitionResult updateSuiteDefinition(UpdateSuiteDefinitionRequest request) {
        request = (UpdateSuiteDefinitionRequest)this.beforeClientExecution(request);
        return this.executeUpdateSuiteDefinition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateSuiteDefinitionResult executeUpdateSuiteDefinition(UpdateSuiteDefinitionRequest updateSuiteDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSuiteDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSuiteDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSuiteDefinitionRequestProtocolMarshaller(protocolFactory).marshall((UpdateSuiteDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateSuiteDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IotDeviceAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateSuiteDefinition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateSuiteDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateSuiteDefinitionResult updateSuiteDefinitionResult = (UpdateSuiteDefinitionResult)response.getAwsResponse();
            return updateSuiteDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

