/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotanalytics.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A summary of information about a channel.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ChannelSummary" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ChannelSummary implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the channel.
     * </p>
     */
    private String channelName;
    /**
     * <p>
     * Where channel data is stored.
     * </p>
     */
    private ChannelStorageSummary channelStorage;
    /**
     * <p>
     * The status of the channel.
     * </p>
     */
    private String status;
    /**
     * <p>
     * When the channel was created.
     * </p>
     */
    private java.util.Date creationTime;
    /**
     * <p>
     * The last time the channel was updated.
     * </p>
     */
    private java.util.Date lastUpdateTime;
    /**
     * <p>
     * The last time when a new message arrived in the channel.
     * </p>
     * <p>
     * IoT Analytics updates this value at most once per minute for one channel. Hence, the
     * <code>lastMessageArrivalTime</code> value is an approximation.
     * </p>
     * <p>
     * This feature only applies to messages that arrived in the data store after October 23, 2020.
     * </p>
     */
    private java.util.Date lastMessageArrivalTime;

    /**
     * <p>
     * The name of the channel.
     * </p>
     * 
     * @param channelName
     *        The name of the channel.
     */

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    /**
     * <p>
     * The name of the channel.
     * </p>
     * 
     * @return The name of the channel.
     */

    public String getChannelName() {
        return this.channelName;
    }

    /**
     * <p>
     * The name of the channel.
     * </p>
     * 
     * @param channelName
     *        The name of the channel.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ChannelSummary withChannelName(String channelName) {
        setChannelName(channelName);
        return this;
    }

    /**
     * <p>
     * Where channel data is stored.
     * </p>
     * 
     * @param channelStorage
     *        Where channel data is stored.
     */

    public void setChannelStorage(ChannelStorageSummary channelStorage) {
        this.channelStorage = channelStorage;
    }

    /**
     * <p>
     * Where channel data is stored.
     * </p>
     * 
     * @return Where channel data is stored.
     */

    public ChannelStorageSummary getChannelStorage() {
        return this.channelStorage;
    }

    /**
     * <p>
     * Where channel data is stored.
     * </p>
     * 
     * @param channelStorage
     *        Where channel data is stored.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ChannelSummary withChannelStorage(ChannelStorageSummary channelStorage) {
        setChannelStorage(channelStorage);
        return this;
    }

    /**
     * <p>
     * The status of the channel.
     * </p>
     * 
     * @param status
     *        The status of the channel.
     * @see ChannelStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The status of the channel.
     * </p>
     * 
     * @return The status of the channel.
     * @see ChannelStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The status of the channel.
     * </p>
     * 
     * @param status
     *        The status of the channel.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ChannelStatus
     */

    public ChannelSummary withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The status of the channel.
     * </p>
     * 
     * @param status
     *        The status of the channel.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ChannelStatus
     */

    public ChannelSummary withStatus(ChannelStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * <p>
     * When the channel was created.
     * </p>
     * 
     * @param creationTime
     *        When the channel was created.
     */

    public void setCreationTime(java.util.Date creationTime) {
        this.creationTime = creationTime;
    }

    /**
     * <p>
     * When the channel was created.
     * </p>
     * 
     * @return When the channel was created.
     */

    public java.util.Date getCreationTime() {
        return this.creationTime;
    }

    /**
     * <p>
     * When the channel was created.
     * </p>
     * 
     * @param creationTime
     *        When the channel was created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ChannelSummary withCreationTime(java.util.Date creationTime) {
        setCreationTime(creationTime);
        return this;
    }

    /**
     * <p>
     * The last time the channel was updated.
     * </p>
     * 
     * @param lastUpdateTime
     *        The last time the channel was updated.
     */

    public void setLastUpdateTime(java.util.Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    /**
     * <p>
     * The last time the channel was updated.
     * </p>
     * 
     * @return The last time the channel was updated.
     */

    public java.util.Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    /**
     * <p>
     * The last time the channel was updated.
     * </p>
     * 
     * @param lastUpdateTime
     *        The last time the channel was updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ChannelSummary withLastUpdateTime(java.util.Date lastUpdateTime) {
        setLastUpdateTime(lastUpdateTime);
        return this;
    }

    /**
     * <p>
     * The last time when a new message arrived in the channel.
     * </p>
     * <p>
     * IoT Analytics updates this value at most once per minute for one channel. Hence, the
     * <code>lastMessageArrivalTime</code> value is an approximation.
     * </p>
     * <p>
     * This feature only applies to messages that arrived in the data store after October 23, 2020.
     * </p>
     * 
     * @param lastMessageArrivalTime
     *        The last time when a new message arrived in the channel.</p>
     *        <p>
     *        IoT Analytics updates this value at most once per minute for one channel. Hence, the
     *        <code>lastMessageArrivalTime</code> value is an approximation.
     *        </p>
     *        <p>
     *        This feature only applies to messages that arrived in the data store after October 23, 2020.
     */

    public void setLastMessageArrivalTime(java.util.Date lastMessageArrivalTime) {
        this.lastMessageArrivalTime = lastMessageArrivalTime;
    }

    /**
     * <p>
     * The last time when a new message arrived in the channel.
     * </p>
     * <p>
     * IoT Analytics updates this value at most once per minute for one channel. Hence, the
     * <code>lastMessageArrivalTime</code> value is an approximation.
     * </p>
     * <p>
     * This feature only applies to messages that arrived in the data store after October 23, 2020.
     * </p>
     * 
     * @return The last time when a new message arrived in the channel.</p>
     *         <p>
     *         IoT Analytics updates this value at most once per minute for one channel. Hence, the
     *         <code>lastMessageArrivalTime</code> value is an approximation.
     *         </p>
     *         <p>
     *         This feature only applies to messages that arrived in the data store after October 23, 2020.
     */

    public java.util.Date getLastMessageArrivalTime() {
        return this.lastMessageArrivalTime;
    }

    /**
     * <p>
     * The last time when a new message arrived in the channel.
     * </p>
     * <p>
     * IoT Analytics updates this value at most once per minute for one channel. Hence, the
     * <code>lastMessageArrivalTime</code> value is an approximation.
     * </p>
     * <p>
     * This feature only applies to messages that arrived in the data store after October 23, 2020.
     * </p>
     * 
     * @param lastMessageArrivalTime
     *        The last time when a new message arrived in the channel.</p>
     *        <p>
     *        IoT Analytics updates this value at most once per minute for one channel. Hence, the
     *        <code>lastMessageArrivalTime</code> value is an approximation.
     *        </p>
     *        <p>
     *        This feature only applies to messages that arrived in the data store after October 23, 2020.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ChannelSummary withLastMessageArrivalTime(java.util.Date lastMessageArrivalTime) {
        setLastMessageArrivalTime(lastMessageArrivalTime);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getChannelName() != null)
            sb.append("ChannelName: ").append(getChannelName()).append(",");
        if (getChannelStorage() != null)
            sb.append("ChannelStorage: ").append(getChannelStorage()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getCreationTime() != null)
            sb.append("CreationTime: ").append(getCreationTime()).append(",");
        if (getLastUpdateTime() != null)
            sb.append("LastUpdateTime: ").append(getLastUpdateTime()).append(",");
        if (getLastMessageArrivalTime() != null)
            sb.append("LastMessageArrivalTime: ").append(getLastMessageArrivalTime());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ChannelSummary == false)
            return false;
        ChannelSummary other = (ChannelSummary) obj;
        if (other.getChannelName() == null ^ this.getChannelName() == null)
            return false;
        if (other.getChannelName() != null && other.getChannelName().equals(this.getChannelName()) == false)
            return false;
        if (other.getChannelStorage() == null ^ this.getChannelStorage() == null)
            return false;
        if (other.getChannelStorage() != null && other.getChannelStorage().equals(this.getChannelStorage()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getCreationTime() == null ^ this.getCreationTime() == null)
            return false;
        if (other.getCreationTime() != null && other.getCreationTime().equals(this.getCreationTime()) == false)
            return false;
        if (other.getLastUpdateTime() == null ^ this.getLastUpdateTime() == null)
            return false;
        if (other.getLastUpdateTime() != null && other.getLastUpdateTime().equals(this.getLastUpdateTime()) == false)
            return false;
        if (other.getLastMessageArrivalTime() == null ^ this.getLastMessageArrivalTime() == null)
            return false;
        if (other.getLastMessageArrivalTime() != null && other.getLastMessageArrivalTime().equals(this.getLastMessageArrivalTime()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getChannelName() == null) ? 0 : getChannelName().hashCode());
        hashCode = prime * hashCode + ((getChannelStorage() == null) ? 0 : getChannelStorage().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getCreationTime() == null) ? 0 : getCreationTime().hashCode());
        hashCode = prime * hashCode + ((getLastUpdateTime() == null) ? 0 : getLastUpdateTime().hashCode());
        hashCode = prime * hashCode + ((getLastMessageArrivalTime() == null) ? 0 : getLastMessageArrivalTime().hashCode());
        return hashCode;
    }

    @Override
    public ChannelSummary clone() {
        try {
            return (ChannelSummary) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.iotanalytics.model.transform.ChannelSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
