/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotanalytics.model.DatastorePartition;
import com.amazonaws.services.iotanalytics.model.transform.DatastorePartitionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DatastorePartitions
implements Serializable,
Cloneable,
StructuredPojo {
    private List<DatastorePartition> partitions;

    public List<DatastorePartition> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(Collection<DatastorePartition> partitions) {
        if (partitions == null) {
            this.partitions = null;
            return;
        }
        this.partitions = new ArrayList<DatastorePartition>(partitions);
    }

    public DatastorePartitions withPartitions(DatastorePartition ... partitions) {
        if (this.partitions == null) {
            this.setPartitions(new ArrayList<DatastorePartition>(partitions.length));
        }
        for (DatastorePartition ele : partitions) {
            this.partitions.add(ele);
        }
        return this;
    }

    public DatastorePartitions withPartitions(Collection<DatastorePartition> partitions) {
        this.setPartitions(partitions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPartitions() != null) {
            sb.append("Partitions: ").append(this.getPartitions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastorePartitions)) {
            return false;
        }
        DatastorePartitions other = (DatastorePartitions)obj;
        if (other.getPartitions() == null ^ this.getPartitions() == null) {
            return false;
        }
        return other.getPartitions() == null || other.getPartitions().equals(this.getPartitions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPartitions() == null ? 0 : this.getPartitions().hashCode());
        return hashCode;
    }

    public DatastorePartitions clone() {
        try {
            return (DatastorePartitions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DatastorePartitionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

