/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotanalytics.model.Dataset;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class DatasetMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<List> ACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actions").build();
    private static final MarshallingInfo<List> TRIGGERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("triggers").build();
    private static final MarshallingInfo<List> CONTENTDELIVERYRULES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contentDeliveryRules").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> RETENTIONPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("retentionPeriod").build();
    private static final DatasetMarshaller instance = new DatasetMarshaller();

    public static DatasetMarshaller getInstance() {
        return instance;
    }

    public void marshall(Dataset dataset, ProtocolMarshaller protocolMarshaller) {
        if (dataset == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataset.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)dataset.getArn(), ARN_BINDING);
            protocolMarshaller.marshall(dataset.getActions(), ACTIONS_BINDING);
            protocolMarshaller.marshall(dataset.getTriggers(), TRIGGERS_BINDING);
            protocolMarshaller.marshall(dataset.getContentDeliveryRules(), CONTENTDELIVERYRULES_BINDING);
            protocolMarshaller.marshall((Object)dataset.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)dataset.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)dataset.getLastUpdateTime(), LASTUPDATETIME_BINDING);
            protocolMarshaller.marshall((Object)dataset.getRetentionPeriod(), RETENTIONPERIOD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

