/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.StreamFile;

@SdkInternalApi
public class StreamFileMarshaller {
    private static final MarshallingInfo<Integer> FILEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileId").build();
    private static final MarshallingInfo<StructuredPojo> S3LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Location").build();
    private static final StreamFileMarshaller instance = new StreamFileMarshaller();

    public static StreamFileMarshaller getInstance() {
        return instance;
    }

    public void marshall(StreamFile streamFile, ProtocolMarshaller protocolMarshaller) {
        if (streamFile == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)streamFile.getFileId(), FILEID_BINDING);
            protocolMarshaller.marshall((Object)streamFile.getS3Location(), S3LOCATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

