/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.HttpActionHeader;
import com.amazonaws.services.iot.model.HttpAuthorization;
import com.amazonaws.services.iot.model.transform.HttpActionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HttpAction
implements Serializable,
Cloneable,
StructuredPojo {
    private String url;
    private String confirmationUrl;
    private List<HttpActionHeader> headers;
    private HttpAuthorization auth;

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public HttpAction withUrl(String url) {
        this.setUrl(url);
        return this;
    }

    public void setConfirmationUrl(String confirmationUrl) {
        this.confirmationUrl = confirmationUrl;
    }

    public String getConfirmationUrl() {
        return this.confirmationUrl;
    }

    public HttpAction withConfirmationUrl(String confirmationUrl) {
        this.setConfirmationUrl(confirmationUrl);
        return this;
    }

    public List<HttpActionHeader> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Collection<HttpActionHeader> headers) {
        if (headers == null) {
            this.headers = null;
            return;
        }
        this.headers = new ArrayList<HttpActionHeader>(headers);
    }

    public HttpAction withHeaders(HttpActionHeader ... headers) {
        if (this.headers == null) {
            this.setHeaders(new ArrayList<HttpActionHeader>(headers.length));
        }
        for (HttpActionHeader ele : headers) {
            this.headers.add(ele);
        }
        return this;
    }

    public HttpAction withHeaders(Collection<HttpActionHeader> headers) {
        this.setHeaders(headers);
        return this;
    }

    public void setAuth(HttpAuthorization auth) {
        this.auth = auth;
    }

    public HttpAuthorization getAuth() {
        return this.auth;
    }

    public HttpAction withAuth(HttpAuthorization auth) {
        this.setAuth(auth);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUrl() != null) {
            sb.append("Url: ").append(this.getUrl()).append(",");
        }
        if (this.getConfirmationUrl() != null) {
            sb.append("ConfirmationUrl: ").append(this.getConfirmationUrl()).append(",");
        }
        if (this.getHeaders() != null) {
            sb.append("Headers: ").append(this.getHeaders()).append(",");
        }
        if (this.getAuth() != null) {
            sb.append("Auth: ").append(this.getAuth());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpAction)) {
            return false;
        }
        HttpAction other = (HttpAction)obj;
        if (other.getUrl() == null ^ this.getUrl() == null) {
            return false;
        }
        if (other.getUrl() != null && !other.getUrl().equals(this.getUrl())) {
            return false;
        }
        if (other.getConfirmationUrl() == null ^ this.getConfirmationUrl() == null) {
            return false;
        }
        if (other.getConfirmationUrl() != null && !other.getConfirmationUrl().equals(this.getConfirmationUrl())) {
            return false;
        }
        if (other.getHeaders() == null ^ this.getHeaders() == null) {
            return false;
        }
        if (other.getHeaders() != null && !other.getHeaders().equals(this.getHeaders())) {
            return false;
        }
        if (other.getAuth() == null ^ this.getAuth() == null) {
            return false;
        }
        return other.getAuth() == null || other.getAuth().equals(this.getAuth());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUrl() == null ? 0 : this.getUrl().hashCode());
        hashCode = 31 * hashCode + (this.getConfirmationUrl() == null ? 0 : this.getConfirmationUrl().hashCode());
        hashCode = 31 * hashCode + (this.getHeaders() == null ? 0 : this.getHeaders().hashCode());
        hashCode = 31 * hashCode + (this.getAuth() == null ? 0 : this.getAuth().hashCode());
        return hashCode;
    }

    public HttpAction clone() {
        try {
            return (HttpAction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HttpActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

