/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdata;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.iotdata.AWSIotDataAsync;
import com.amazonaws.services.iotdata.AWSIotDataAsyncClientBuilder;
import com.amazonaws.services.iotdata.AWSIotDataClient;
import com.amazonaws.services.iotdata.model.DeleteThingShadowRequest;
import com.amazonaws.services.iotdata.model.DeleteThingShadowResult;
import com.amazonaws.services.iotdata.model.GetThingShadowRequest;
import com.amazonaws.services.iotdata.model.GetThingShadowResult;
import com.amazonaws.services.iotdata.model.ListNamedShadowsForThingRequest;
import com.amazonaws.services.iotdata.model.ListNamedShadowsForThingResult;
import com.amazonaws.services.iotdata.model.PublishRequest;
import com.amazonaws.services.iotdata.model.PublishResult;
import com.amazonaws.services.iotdata.model.UpdateThingShadowRequest;
import com.amazonaws.services.iotdata.model.UpdateThingShadowResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSIotDataAsyncClient
extends AWSIotDataClient
implements AWSIotDataAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSIotDataAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSIotDataAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSIotDataAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSIotDataAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSIotDataAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSIotDataAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSIotDataAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSIotDataAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSIotDataAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSIotDataAsyncClientBuilder asyncBuilder() {
        return AWSIotDataAsyncClientBuilder.standard();
    }

    AWSIotDataAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSIotDataAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteThingShadowResult> deleteThingShadowAsync(DeleteThingShadowRequest request) {
        return this.deleteThingShadowAsync(request, null);
    }

    @Override
    public Future<DeleteThingShadowResult> deleteThingShadowAsync(DeleteThingShadowRequest request, final AsyncHandler<DeleteThingShadowRequest, DeleteThingShadowResult> asyncHandler) {
        final DeleteThingShadowRequest finalRequest = (DeleteThingShadowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteThingShadowResult>(){

            @Override
            public DeleteThingShadowResult call() throws Exception {
                DeleteThingShadowResult result = null;
                try {
                    result = AWSIotDataAsyncClient.this.executeDeleteThingShadow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetThingShadowResult> getThingShadowAsync(GetThingShadowRequest request) {
        return this.getThingShadowAsync(request, null);
    }

    @Override
    public Future<GetThingShadowResult> getThingShadowAsync(GetThingShadowRequest request, final AsyncHandler<GetThingShadowRequest, GetThingShadowResult> asyncHandler) {
        final GetThingShadowRequest finalRequest = (GetThingShadowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetThingShadowResult>(){

            @Override
            public GetThingShadowResult call() throws Exception {
                GetThingShadowResult result = null;
                try {
                    result = AWSIotDataAsyncClient.this.executeGetThingShadow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNamedShadowsForThingResult> listNamedShadowsForThingAsync(ListNamedShadowsForThingRequest request) {
        return this.listNamedShadowsForThingAsync(request, null);
    }

    @Override
    public Future<ListNamedShadowsForThingResult> listNamedShadowsForThingAsync(ListNamedShadowsForThingRequest request, final AsyncHandler<ListNamedShadowsForThingRequest, ListNamedShadowsForThingResult> asyncHandler) {
        final ListNamedShadowsForThingRequest finalRequest = (ListNamedShadowsForThingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNamedShadowsForThingResult>(){

            @Override
            public ListNamedShadowsForThingResult call() throws Exception {
                ListNamedShadowsForThingResult result = null;
                try {
                    result = AWSIotDataAsyncClient.this.executeListNamedShadowsForThing(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PublishResult> publishAsync(PublishRequest request) {
        return this.publishAsync(request, null);
    }

    @Override
    public Future<PublishResult> publishAsync(PublishRequest request, final AsyncHandler<PublishRequest, PublishResult> asyncHandler) {
        final PublishRequest finalRequest = (PublishRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PublishResult>(){

            @Override
            public PublishResult call() throws Exception {
                PublishResult result = null;
                try {
                    result = AWSIotDataAsyncClient.this.executePublish(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateThingShadowResult> updateThingShadowAsync(UpdateThingShadowRequest request) {
        return this.updateThingShadowAsync(request, null);
    }

    @Override
    public Future<UpdateThingShadowResult> updateThingShadowAsync(UpdateThingShadowRequest request, final AsyncHandler<UpdateThingShadowRequest, UpdateThingShadowResult> asyncHandler) {
        final UpdateThingShadowRequest finalRequest = (UpdateThingShadowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateThingShadowResult>(){

            @Override
            public UpdateThingShadowResult call() throws Exception {
                UpdateThingShadowResult result = null;
                try {
                    result = AWSIotDataAsyncClient.this.executeUpdateThingShadow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

