/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.iot.model.Action;
import com.amazonaws.services.iot.model.ReplaceTopicRuleRequest;
import com.amazonaws.services.iot.model.TopicRulePayload;
import com.amazonaws.services.iot.model.transform.ActionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class ReplaceTopicRuleRequestMarshaller
implements Marshaller<Request<ReplaceTopicRuleRequest>, ReplaceTopicRuleRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ReplaceTopicRuleRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ReplaceTopicRuleRequest> marshall(ReplaceTopicRuleRequest replaceTopicRuleRequest) {
        if (replaceTopicRuleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)replaceTopicRuleRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.PATCH);
        String uriResourcePath = "/rules/{ruleName}";
        uriResourcePath = uriResourcePath.replace("{ruleName}", replaceTopicRuleRequest.getRuleName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)replaceTopicRuleRequest.getRuleName()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            TopicRulePayload topicRulePayload = replaceTopicRuleRequest.getTopicRulePayload();
            if (topicRulePayload != null) {
                List<Action> actionsList;
                jsonGenerator.writeStartObject();
                if (topicRulePayload.getSql() != null) {
                    jsonGenerator.writeFieldName("sql").writeValue(topicRulePayload.getSql());
                }
                if (topicRulePayload.getDescription() != null) {
                    jsonGenerator.writeFieldName("description").writeValue(topicRulePayload.getDescription());
                }
                if ((actionsList = topicRulePayload.getActions()) != null) {
                    jsonGenerator.writeFieldName("actions");
                    jsonGenerator.writeStartArray();
                    for (Action actionsListValue : actionsList) {
                        if (actionsListValue == null) continue;
                        ActionJsonMarshaller.getInstance().marshall(actionsListValue, jsonGenerator);
                    }
                    jsonGenerator.writeEndArray();
                }
                if (topicRulePayload.getRuleDisabled() != null) {
                    jsonGenerator.writeFieldName("ruleDisabled").writeValue(topicRulePayload.getRuleDisabled().booleanValue());
                }
                if (topicRulePayload.getAwsIotSqlVersion() != null) {
                    jsonGenerator.writeFieldName("awsIotSqlVersion").writeValue(topicRulePayload.getAwsIotSqlVersion());
                }
                jsonGenerator.writeEndObject();
            }
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

