/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iot.model.AlertTarget;
import com.amazonaws.services.iot.model.Behavior;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateSecurityProfileRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String securityProfileName;
    private String securityProfileDescription;
    private List<Behavior> behaviors;
    private Map<String, AlertTarget> alertTargets;
    private List<String> additionalMetricsToRetain;
    private Boolean deleteBehaviors;
    private Boolean deleteAlertTargets;
    private Boolean deleteAdditionalMetricsToRetain;
    private Long expectedVersion;

    public void setSecurityProfileName(String securityProfileName) {
        this.securityProfileName = securityProfileName;
    }

    public String getSecurityProfileName() {
        return this.securityProfileName;
    }

    public UpdateSecurityProfileRequest withSecurityProfileName(String securityProfileName) {
        this.setSecurityProfileName(securityProfileName);
        return this;
    }

    public void setSecurityProfileDescription(String securityProfileDescription) {
        this.securityProfileDescription = securityProfileDescription;
    }

    public String getSecurityProfileDescription() {
        return this.securityProfileDescription;
    }

    public UpdateSecurityProfileRequest withSecurityProfileDescription(String securityProfileDescription) {
        this.setSecurityProfileDescription(securityProfileDescription);
        return this;
    }

    public List<Behavior> getBehaviors() {
        return this.behaviors;
    }

    public void setBehaviors(Collection<Behavior> behaviors) {
        if (behaviors == null) {
            this.behaviors = null;
            return;
        }
        this.behaviors = new ArrayList<Behavior>(behaviors);
    }

    public UpdateSecurityProfileRequest withBehaviors(Behavior ... behaviors) {
        if (this.behaviors == null) {
            this.setBehaviors(new ArrayList<Behavior>(behaviors.length));
        }
        for (Behavior ele : behaviors) {
            this.behaviors.add(ele);
        }
        return this;
    }

    public UpdateSecurityProfileRequest withBehaviors(Collection<Behavior> behaviors) {
        this.setBehaviors(behaviors);
        return this;
    }

    public Map<String, AlertTarget> getAlertTargets() {
        return this.alertTargets;
    }

    public void setAlertTargets(Map<String, AlertTarget> alertTargets) {
        this.alertTargets = alertTargets;
    }

    public UpdateSecurityProfileRequest withAlertTargets(Map<String, AlertTarget> alertTargets) {
        this.setAlertTargets(alertTargets);
        return this;
    }

    public UpdateSecurityProfileRequest addAlertTargetsEntry(String key, AlertTarget value) {
        if (null == this.alertTargets) {
            this.alertTargets = new HashMap<String, AlertTarget>();
        }
        if (this.alertTargets.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.alertTargets.put(key, value);
        return this;
    }

    public UpdateSecurityProfileRequest clearAlertTargetsEntries() {
        this.alertTargets = null;
        return this;
    }

    public List<String> getAdditionalMetricsToRetain() {
        return this.additionalMetricsToRetain;
    }

    public void setAdditionalMetricsToRetain(Collection<String> additionalMetricsToRetain) {
        if (additionalMetricsToRetain == null) {
            this.additionalMetricsToRetain = null;
            return;
        }
        this.additionalMetricsToRetain = new ArrayList<String>(additionalMetricsToRetain);
    }

    public UpdateSecurityProfileRequest withAdditionalMetricsToRetain(String ... additionalMetricsToRetain) {
        if (this.additionalMetricsToRetain == null) {
            this.setAdditionalMetricsToRetain(new ArrayList<String>(additionalMetricsToRetain.length));
        }
        for (String ele : additionalMetricsToRetain) {
            this.additionalMetricsToRetain.add(ele);
        }
        return this;
    }

    public UpdateSecurityProfileRequest withAdditionalMetricsToRetain(Collection<String> additionalMetricsToRetain) {
        this.setAdditionalMetricsToRetain(additionalMetricsToRetain);
        return this;
    }

    public void setDeleteBehaviors(Boolean deleteBehaviors) {
        this.deleteBehaviors = deleteBehaviors;
    }

    public Boolean getDeleteBehaviors() {
        return this.deleteBehaviors;
    }

    public UpdateSecurityProfileRequest withDeleteBehaviors(Boolean deleteBehaviors) {
        this.setDeleteBehaviors(deleteBehaviors);
        return this;
    }

    public Boolean isDeleteBehaviors() {
        return this.deleteBehaviors;
    }

    public void setDeleteAlertTargets(Boolean deleteAlertTargets) {
        this.deleteAlertTargets = deleteAlertTargets;
    }

    public Boolean getDeleteAlertTargets() {
        return this.deleteAlertTargets;
    }

    public UpdateSecurityProfileRequest withDeleteAlertTargets(Boolean deleteAlertTargets) {
        this.setDeleteAlertTargets(deleteAlertTargets);
        return this;
    }

    public Boolean isDeleteAlertTargets() {
        return this.deleteAlertTargets;
    }

    public void setDeleteAdditionalMetricsToRetain(Boolean deleteAdditionalMetricsToRetain) {
        this.deleteAdditionalMetricsToRetain = deleteAdditionalMetricsToRetain;
    }

    public Boolean getDeleteAdditionalMetricsToRetain() {
        return this.deleteAdditionalMetricsToRetain;
    }

    public UpdateSecurityProfileRequest withDeleteAdditionalMetricsToRetain(Boolean deleteAdditionalMetricsToRetain) {
        this.setDeleteAdditionalMetricsToRetain(deleteAdditionalMetricsToRetain);
        return this;
    }

    public Boolean isDeleteAdditionalMetricsToRetain() {
        return this.deleteAdditionalMetricsToRetain;
    }

    public void setExpectedVersion(Long expectedVersion) {
        this.expectedVersion = expectedVersion;
    }

    public Long getExpectedVersion() {
        return this.expectedVersion;
    }

    public UpdateSecurityProfileRequest withExpectedVersion(Long expectedVersion) {
        this.setExpectedVersion(expectedVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSecurityProfileName() != null) {
            sb.append("SecurityProfileName: ").append(this.getSecurityProfileName()).append(",");
        }
        if (this.getSecurityProfileDescription() != null) {
            sb.append("SecurityProfileDescription: ").append(this.getSecurityProfileDescription()).append(",");
        }
        if (this.getBehaviors() != null) {
            sb.append("Behaviors: ").append(this.getBehaviors()).append(",");
        }
        if (this.getAlertTargets() != null) {
            sb.append("AlertTargets: ").append(this.getAlertTargets()).append(",");
        }
        if (this.getAdditionalMetricsToRetain() != null) {
            sb.append("AdditionalMetricsToRetain: ").append(this.getAdditionalMetricsToRetain()).append(",");
        }
        if (this.getDeleteBehaviors() != null) {
            sb.append("DeleteBehaviors: ").append(this.getDeleteBehaviors()).append(",");
        }
        if (this.getDeleteAlertTargets() != null) {
            sb.append("DeleteAlertTargets: ").append(this.getDeleteAlertTargets()).append(",");
        }
        if (this.getDeleteAdditionalMetricsToRetain() != null) {
            sb.append("DeleteAdditionalMetricsToRetain: ").append(this.getDeleteAdditionalMetricsToRetain()).append(",");
        }
        if (this.getExpectedVersion() != null) {
            sb.append("ExpectedVersion: ").append(this.getExpectedVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityProfileRequest)) {
            return false;
        }
        UpdateSecurityProfileRequest other = (UpdateSecurityProfileRequest)obj;
        if (other.getSecurityProfileName() == null ^ this.getSecurityProfileName() == null) {
            return false;
        }
        if (other.getSecurityProfileName() != null && !other.getSecurityProfileName().equals(this.getSecurityProfileName())) {
            return false;
        }
        if (other.getSecurityProfileDescription() == null ^ this.getSecurityProfileDescription() == null) {
            return false;
        }
        if (other.getSecurityProfileDescription() != null && !other.getSecurityProfileDescription().equals(this.getSecurityProfileDescription())) {
            return false;
        }
        if (other.getBehaviors() == null ^ this.getBehaviors() == null) {
            return false;
        }
        if (other.getBehaviors() != null && !other.getBehaviors().equals(this.getBehaviors())) {
            return false;
        }
        if (other.getAlertTargets() == null ^ this.getAlertTargets() == null) {
            return false;
        }
        if (other.getAlertTargets() != null && !other.getAlertTargets().equals(this.getAlertTargets())) {
            return false;
        }
        if (other.getAdditionalMetricsToRetain() == null ^ this.getAdditionalMetricsToRetain() == null) {
            return false;
        }
        if (other.getAdditionalMetricsToRetain() != null && !other.getAdditionalMetricsToRetain().equals(this.getAdditionalMetricsToRetain())) {
            return false;
        }
        if (other.getDeleteBehaviors() == null ^ this.getDeleteBehaviors() == null) {
            return false;
        }
        if (other.getDeleteBehaviors() != null && !other.getDeleteBehaviors().equals(this.getDeleteBehaviors())) {
            return false;
        }
        if (other.getDeleteAlertTargets() == null ^ this.getDeleteAlertTargets() == null) {
            return false;
        }
        if (other.getDeleteAlertTargets() != null && !other.getDeleteAlertTargets().equals(this.getDeleteAlertTargets())) {
            return false;
        }
        if (other.getDeleteAdditionalMetricsToRetain() == null ^ this.getDeleteAdditionalMetricsToRetain() == null) {
            return false;
        }
        if (other.getDeleteAdditionalMetricsToRetain() != null && !other.getDeleteAdditionalMetricsToRetain().equals(this.getDeleteAdditionalMetricsToRetain())) {
            return false;
        }
        if (other.getExpectedVersion() == null ^ this.getExpectedVersion() == null) {
            return false;
        }
        return other.getExpectedVersion() == null || other.getExpectedVersion().equals(this.getExpectedVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSecurityProfileName() == null ? 0 : this.getSecurityProfileName().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityProfileDescription() == null ? 0 : this.getSecurityProfileDescription().hashCode());
        hashCode = 31 * hashCode + (this.getBehaviors() == null ? 0 : this.getBehaviors().hashCode());
        hashCode = 31 * hashCode + (this.getAlertTargets() == null ? 0 : this.getAlertTargets().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalMetricsToRetain() == null ? 0 : this.getAdditionalMetricsToRetain().hashCode());
        hashCode = 31 * hashCode + (this.getDeleteBehaviors() == null ? 0 : this.getDeleteBehaviors().hashCode());
        hashCode = 31 * hashCode + (this.getDeleteAlertTargets() == null ? 0 : this.getDeleteAlertTargets().hashCode());
        hashCode = 31 * hashCode + (this.getDeleteAdditionalMetricsToRetain() == null ? 0 : this.getDeleteAdditionalMetricsToRetain().hashCode());
        hashCode = 31 * hashCode + (this.getExpectedVersion() == null ? 0 : this.getExpectedVersion().hashCode());
        return hashCode;
    }

    public UpdateSecurityProfileRequest clone() {
        return (UpdateSecurityProfileRequest)super.clone();
    }
}

