/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.iot.model.ThingAttribute;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.util.Map;

public class ThingAttributeJsonMarshaller {
    private static ThingAttributeJsonMarshaller instance;

    public void marshall(ThingAttribute thingAttribute, SdkJsonGenerator jsonGenerator) {
        if (thingAttribute == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> attributesMap;
            jsonGenerator.writeStartObject();
            if (thingAttribute.getThingName() != null) {
                jsonGenerator.writeFieldName("thingName").writeValue(thingAttribute.getThingName());
            }
            if ((attributesMap = thingAttribute.getAttributes()) != null) {
                jsonGenerator.writeFieldName("attributes");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(attributesMapValue.getKey());
                    jsonGenerator.writeValue(attributesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ThingAttributeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ThingAttributeJsonMarshaller();
        }
        return instance;
    }
}

