/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.iot.model.Action;
import com.amazonaws.services.iot.model.TopicRulePayload;
import com.amazonaws.services.iot.model.transform.ActionJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class TopicRulePayloadJsonMarshaller {
    private static TopicRulePayloadJsonMarshaller instance;

    public void marshall(TopicRulePayload topicRulePayload, JSONWriter jsonWriter) {
        if (topicRulePayload == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Action> actionsList;
            jsonWriter.object();
            if (topicRulePayload.getSql() != null) {
                jsonWriter.key("sql").value((Object)topicRulePayload.getSql());
            }
            if (topicRulePayload.getDescription() != null) {
                jsonWriter.key("description").value((Object)topicRulePayload.getDescription());
            }
            if ((actionsList = topicRulePayload.getActions()) != null) {
                jsonWriter.key("actions");
                jsonWriter.array();
                for (Action actionsListValue : actionsList) {
                    if (actionsListValue == null) continue;
                    ActionJsonMarshaller.getInstance().marshall(actionsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (topicRulePayload.getRuleDisabled() != null) {
                jsonWriter.key("ruleDisabled").value((Object)topicRulePayload.getRuleDisabled());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TopicRulePayloadJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TopicRulePayloadJsonMarshaller();
        }
        return instance;
    }
}

