/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListTopicRulesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListTopicRulesRequestMarshaller
implements Marshaller<Request<ListTopicRulesRequest>, ListTopicRulesRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<ListTopicRulesRequest> marshall(ListTopicRulesRequest listTopicRulesRequest) {
        String ruleDisabled;
        String nextToken;
        String maxResults;
        String topic;
        if (listTopicRulesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listTopicRulesRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/rules";
        request.setResourcePath(uriResourcePath);
        String string = topic = listTopicRulesRequest.getTopic() == null ? null : StringUtils.fromString((String)listTopicRulesRequest.getTopic());
        if (topic != null) {
            request.addParameter("topic", topic);
        }
        String string2 = maxResults = listTopicRulesRequest.getMaxResults() == null ? null : StringUtils.fromInteger((Integer)listTopicRulesRequest.getMaxResults());
        if (maxResults != null) {
            request.addParameter("maxResults", maxResults);
        }
        String string3 = nextToken = listTopicRulesRequest.getNextToken() == null ? null : StringUtils.fromString((String)listTopicRulesRequest.getNextToken());
        if (nextToken != null) {
            request.addParameter("nextToken", nextToken);
        }
        String string4 = ruleDisabled = listTopicRulesRequest.getRuleDisabled() == null ? null : StringUtils.fromBoolean((Boolean)listTopicRulesRequest.getRuleDisabled());
        if (ruleDisabled != null) {
            request.addParameter("ruleDisabled", ruleDisabled);
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

