/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListThingsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListThingsRequestMarshaller
implements Marshaller<Request<ListThingsRequest>, ListThingsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<ListThingsRequest> marshall(ListThingsRequest listThingsRequest) {
        String attributeValue;
        String attributeName;
        String maxResults;
        String nextToken;
        if (listThingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listThingsRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/things";
        request.setResourcePath(uriResourcePath);
        String string = nextToken = listThingsRequest.getNextToken() == null ? null : StringUtils.fromString((String)listThingsRequest.getNextToken());
        if (nextToken != null) {
            request.addParameter("nextToken", nextToken);
        }
        String string2 = maxResults = listThingsRequest.getMaxResults() == null ? null : StringUtils.fromInteger((Integer)listThingsRequest.getMaxResults());
        if (maxResults != null) {
            request.addParameter("maxResults", maxResults);
        }
        String string3 = attributeName = listThingsRequest.getAttributeName() == null ? null : StringUtils.fromString((String)listThingsRequest.getAttributeName());
        if (attributeName != null) {
            request.addParameter("attributeName", attributeName);
        }
        String string4 = attributeValue = listThingsRequest.getAttributeValue() == null ? null : StringUtils.fromString((String)listThingsRequest.getAttributeValue());
        if (attributeValue != null) {
            request.addParameter("attributeValue", attributeValue);
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

