/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListPrincipalThingsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListPrincipalThingsRequestMarshaller
implements Marshaller<Request<ListPrincipalThingsRequest>, ListPrincipalThingsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<ListPrincipalThingsRequest> marshall(ListPrincipalThingsRequest listPrincipalThingsRequest) {
        String maxResults;
        String nextToken;
        if (listPrincipalThingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listPrincipalThingsRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        if (listPrincipalThingsRequest.getPrincipal() != null) {
            request.addHeader("x-amzn-principal", StringUtils.fromString((String)listPrincipalThingsRequest.getPrincipal()));
        }
        String uriResourcePath = "/principals/things";
        request.setResourcePath(uriResourcePath);
        String string = nextToken = listPrincipalThingsRequest.getNextToken() == null ? null : StringUtils.fromString((String)listPrincipalThingsRequest.getNextToken());
        if (nextToken != null) {
            request.addParameter("nextToken", nextToken);
        }
        String string2 = maxResults = listPrincipalThingsRequest.getMaxResults() == null ? null : StringUtils.fromInteger((Integer)listPrincipalThingsRequest.getMaxResults());
        if (maxResults != null) {
            request.addParameter("maxResults", maxResults);
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

