/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.internetmonitor.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.internetmonitor.model.HealthEvent;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class HealthEventMarshaller {
    private static final MarshallingInfo<String> EVENTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventArn").build();
    private static final MarshallingInfo<String> EVENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventId").build();
    private static final MarshallingInfo<Date> STARTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedAt").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> ENDEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndedAt").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> LASTUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedAt").timestampFormat("iso8601").build();
    private static final MarshallingInfo<List> IMPACTEDLOCATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImpactedLocations").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Double> PERCENTOFTOTALTRAFFICIMPACTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PercentOfTotalTrafficImpacted").build();
    private static final MarshallingInfo<String> IMPACTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImpactType").build();
    private static final MarshallingInfo<Double> HEALTHSCORETHRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HealthScoreThreshold").build();
    private static final HealthEventMarshaller instance = new HealthEventMarshaller();

    public static HealthEventMarshaller getInstance() {
        return instance;
    }

    public void marshall(HealthEvent healthEvent, ProtocolMarshaller protocolMarshaller) {
        if (healthEvent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)healthEvent.getEventArn(), EVENTARN_BINDING);
            protocolMarshaller.marshall((Object)healthEvent.getEventId(), EVENTID_BINDING);
            protocolMarshaller.marshall((Object)healthEvent.getStartedAt(), STARTEDAT_BINDING);
            protocolMarshaller.marshall((Object)healthEvent.getEndedAt(), ENDEDAT_BINDING);
            protocolMarshaller.marshall((Object)healthEvent.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)healthEvent.getLastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall(healthEvent.getImpactedLocations(), IMPACTEDLOCATIONS_BINDING);
            protocolMarshaller.marshall((Object)healthEvent.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)healthEvent.getPercentOfTotalTrafficImpacted(), PERCENTOFTOTALTRAFFICIMPACTED_BINDING);
            protocolMarshaller.marshall((Object)healthEvent.getImpactType(), IMPACTTYPE_BINDING);
            protocolMarshaller.marshall((Object)healthEvent.getHealthScoreThreshold(), HEALTHSCORETHRESHOLD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

