/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.internetmonitor.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.internetmonitor.model.StartQueryRequest;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class StartQueryRequestMarshaller {
    private static final MarshallingInfo<String> MONITORNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("MonitorName").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> QUERYTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueryType").build();
    private static final MarshallingInfo<List> FILTERPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FilterParameters").build();
    private static final MarshallingInfo<String> LINKEDACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LinkedAccountId").build();
    private static final StartQueryRequestMarshaller instance = new StartQueryRequestMarshaller();

    public static StartQueryRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(StartQueryRequest startQueryRequest, ProtocolMarshaller protocolMarshaller) {
        if (startQueryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)startQueryRequest.getMonitorName(), MONITORNAME_BINDING);
            protocolMarshaller.marshall((Object)startQueryRequest.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)startQueryRequest.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)startQueryRequest.getQueryType(), QUERYTYPE_BINDING);
            protocolMarshaller.marshall(startQueryRequest.getFilterParameters(), FILTERPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)startQueryRequest.getLinkedAccountId(), LINKEDACCOUNTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

