/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.identitystore.model;

import javax.annotation.Generated;

/**
 * <p>
 * This request cannot be completed for one of the following reasons:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Performing the requested operation would violate an existing uniqueness claim in the identity store. Resolve the
 * conflict before retrying this request.
 * </p>
 * </li>
 * <li>
 * <p>
 * The requested resource was being concurrently modified by another request.
 * </p>
 * </li>
 * </ul>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ConflictException extends com.amazonaws.services.identitystore.model.AWSIdentityStoreException {
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * The identifier for each request. This value is a globally unique ID that is generated by the identity store
     * service for each sent request, and is then returned inside the exception if the request fails.
     * </p>
     */
    private String requestId;
    /**
     * <p>
     * This request cannot be completed for one of the following reasons:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Performing the requested operation would violate an existing uniqueness claim in the identity store. Resolve the
     * conflict before retrying this request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The requested resource was being concurrently modified by another request.
     * </p>
     * </li>
     * </ul>
     */
    private String reason;

    /**
     * Constructs a new ConflictException with the specified error message.
     *
     * @param message
     *        Describes the error encountered.
     */
    public ConflictException(String message) {
        super(message);
    }

    /**
     * <p>
     * The identifier for each request. This value is a globally unique ID that is generated by the identity store
     * service for each sent request, and is then returned inside the exception if the request fails.
     * </p>
     * 
     * @param requestId
     *        The identifier for each request. This value is a globally unique ID that is generated by the identity
     *        store service for each sent request, and is then returned inside the exception if the request fails.
     */

    @com.fasterxml.jackson.annotation.JsonProperty("RequestId")
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    /**
     * <p>
     * The identifier for each request. This value is a globally unique ID that is generated by the identity store
     * service for each sent request, and is then returned inside the exception if the request fails.
     * </p>
     * 
     * @return The identifier for each request. This value is a globally unique ID that is generated by the identity
     *         store service for each sent request, and is then returned inside the exception if the request fails.
     */

    @com.fasterxml.jackson.annotation.JsonProperty("RequestId")
    public String getRequestId() {
        return this.requestId;
    }

    /**
     * <p>
     * The identifier for each request. This value is a globally unique ID that is generated by the identity store
     * service for each sent request, and is then returned inside the exception if the request fails.
     * </p>
     * 
     * @param requestId
     *        The identifier for each request. This value is a globally unique ID that is generated by the identity
     *        store service for each sent request, and is then returned inside the exception if the request fails.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ConflictException withRequestId(String requestId) {
        setRequestId(requestId);
        return this;
    }

    /**
     * <p>
     * This request cannot be completed for one of the following reasons:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Performing the requested operation would violate an existing uniqueness claim in the identity store. Resolve the
     * conflict before retrying this request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The requested resource was being concurrently modified by another request.
     * </p>
     * </li>
     * </ul>
     * 
     * @param reason
     *        This request cannot be completed for one of the following reasons:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *        Resolve the conflict before retrying this request.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The requested resource was being concurrently modified by another request.
     *        </p>
     *        </li>
     * @see ConflictExceptionReason
     */

    @com.fasterxml.jackson.annotation.JsonProperty("Reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    /**
     * <p>
     * This request cannot be completed for one of the following reasons:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Performing the requested operation would violate an existing uniqueness claim in the identity store. Resolve the
     * conflict before retrying this request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The requested resource was being concurrently modified by another request.
     * </p>
     * </li>
     * </ul>
     * 
     * @return This request cannot be completed for one of the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *         Resolve the conflict before retrying this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The requested resource was being concurrently modified by another request.
     *         </p>
     *         </li>
     * @see ConflictExceptionReason
     */

    @com.fasterxml.jackson.annotation.JsonProperty("Reason")
    public String getReason() {
        return this.reason;
    }

    /**
     * <p>
     * This request cannot be completed for one of the following reasons:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Performing the requested operation would violate an existing uniqueness claim in the identity store. Resolve the
     * conflict before retrying this request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The requested resource was being concurrently modified by another request.
     * </p>
     * </li>
     * </ul>
     * 
     * @param reason
     *        This request cannot be completed for one of the following reasons:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *        Resolve the conflict before retrying this request.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The requested resource was being concurrently modified by another request.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ConflictExceptionReason
     */

    public ConflictException withReason(String reason) {
        setReason(reason);
        return this;
    }

    /**
     * <p>
     * This request cannot be completed for one of the following reasons:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Performing the requested operation would violate an existing uniqueness claim in the identity store. Resolve the
     * conflict before retrying this request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The requested resource was being concurrently modified by another request.
     * </p>
     * </li>
     * </ul>
     * 
     * @param reason
     *        This request cannot be completed for one of the following reasons:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        Performing the requested operation would violate an existing uniqueness claim in the identity store.
     *        Resolve the conflict before retrying this request.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The requested resource was being concurrently modified by another request.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ConflictExceptionReason
     */

    public ConflictException withReason(ConflictExceptionReason reason) {
        this.reason = reason.toString();
        return this;
    }

}
