/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iamrolesanywhere.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iamrolesanywhere.model.transform.InstancePropertyMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class InstanceProperty
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean failed;
    private Map<String, String> properties;
    private Date seenAt;

    public void setFailed(Boolean failed) {
        this.failed = failed;
    }

    public Boolean getFailed() {
        return this.failed;
    }

    public InstanceProperty withFailed(Boolean failed) {
        this.setFailed(failed);
        return this;
    }

    public Boolean isFailed() {
        return this.failed;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public InstanceProperty withProperties(Map<String, String> properties) {
        this.setProperties(properties);
        return this;
    }

    public InstanceProperty addPropertiesEntry(String key, String value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>();
        }
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.properties.put(key, value);
        return this;
    }

    public InstanceProperty clearPropertiesEntries() {
        this.properties = null;
        return this;
    }

    public void setSeenAt(Date seenAt) {
        this.seenAt = seenAt;
    }

    public Date getSeenAt() {
        return this.seenAt;
    }

    public InstanceProperty withSeenAt(Date seenAt) {
        this.setSeenAt(seenAt);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFailed() != null) {
            sb.append("Failed: ").append(this.getFailed()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties()).append(",");
        }
        if (this.getSeenAt() != null) {
            sb.append("SeenAt: ").append(this.getSeenAt());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceProperty)) {
            return false;
        }
        InstanceProperty other = (InstanceProperty)obj;
        if (other.getFailed() == null ^ this.getFailed() == null) {
            return false;
        }
        if (other.getFailed() != null && !other.getFailed().equals(this.getFailed())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        if (other.getProperties() != null && !other.getProperties().equals(this.getProperties())) {
            return false;
        }
        if (other.getSeenAt() == null ^ this.getSeenAt() == null) {
            return false;
        }
        return other.getSeenAt() == null || other.getSeenAt().equals(this.getSeenAt());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFailed() == null ? 0 : this.getFailed().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        hashCode = 31 * hashCode + (this.getSeenAt() == null ? 0 : this.getSeenAt().hashCode());
        return hashCode;
    }

    public InstanceProperty clone() {
        try {
            return (InstanceProperty)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstancePropertyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

