/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.identitymanagement.model.CreateRoleRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateRoleRequestMarshaller
implements Marshaller<Request<CreateRoleRequest>, CreateRoleRequest> {
    public Request<CreateRoleRequest> marshall(CreateRoleRequest createRoleRequest) {
        if (createRoleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createRoleRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "CreateRole");
        request.addParameter("Version", "2010-05-08");
        if (createRoleRequest.getPath() != null) {
            request.addParameter("Path", StringUtils.fromString((String)createRoleRequest.getPath()));
        }
        if (createRoleRequest.getRoleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString((String)createRoleRequest.getRoleName()));
        }
        if (createRoleRequest.getAssumeRolePolicyDocument() != null) {
            request.addParameter("AssumeRolePolicyDocument", StringUtils.fromString((String)createRoleRequest.getAssumeRolePolicyDocument()));
        }
        return request;
    }
}

